/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import io.quarkus.mongodb.panache.PanacheQuery;
import io.quarkus.mongodb.panache.runtime.MongoOperations;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import io.quarkus.panache.common.impl.GenerateBridge;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.bson.Document;

public interface PanacheMongoRepositoryBase<Entity, Id> {
    default public void persist(Entity entity) {
        MongoOperations.persist(entity);
    }

    default public void update(Entity entity) {
        MongoOperations.update(entity);
    }

    default public void persistOrUpdate(Entity entity) {
        MongoOperations.persistOrUpdate(entity);
    }

    default public void delete(Entity entity) {
        MongoOperations.delete(entity);
    }

    @GenerateBridge(targetReturnTypeErased=true)
    default public Entity findById(Id id) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Optional<Entity> findByIdOptional(Id id) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Object ... params) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Sort sort, Object ... params) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Map<String, Object> params) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Sort sort, Map<String, Object> params) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Parameters params) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(String query, Sort sort, Parameters params) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(Document query) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> find(Document query, Document sort) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> findAll() {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> findAll(Sort sort) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> list(String query, Object ... params) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> list(String query, Sort sort, Object ... params) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> list(String query, Map<String, Object> params) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> list(String query, Sort sort, Map<String, Object> params) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> list(String query, Parameters params) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> list(String query, Sort sort, Parameters params) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> list(Document query) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> list(Document query, Document sort) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> listAll() {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public List<Entity> listAll(Sort sort) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> stream(String query, Object ... params) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> stream(String query, Sort sort, Object ... params) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> stream(String query, Map<String, Object> params) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> stream(String query, Sort sort, Map<String, Object> params) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> stream(String query, Parameters params) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> stream(String query, Sort sort, Parameters params) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> stream(Document query) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public PanacheQuery<Entity> stream(Document query, Document sort) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> streamAll(Sort sort) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public Stream<Entity> streamAll() {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long count() {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long count(String query, Object ... params) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long count(String query, Map<String, Object> params) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long count(String query, Parameters params) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long count(Document query) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long deleteAll() {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long delete(String query, Object ... params) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long delete(String query, Map<String, Object> params) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long delete(String query, Parameters params) {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public long delete(Document query) {
        throw MongoOperations.implementationInjectionMissing();
    }

    default public void persist(Iterable<Entity> entities) {
        MongoOperations.persist(entities);
    }

    default public void persist(Stream<Entity> entities) {
        MongoOperations.persist(entities);
    }

    default public void persist(Entity firstEntity, Entity ... entities) {
        MongoOperations.persist(firstEntity, entities);
    }

    default public void update(Iterable<Entity> entities) {
        MongoOperations.update(entities);
    }

    default public void update(Stream<Entity> entities) {
        MongoOperations.update(entities);
    }

    default public void update(Entity firstEntity, Entity ... entities) {
        MongoOperations.update(firstEntity, entities);
    }

    default public void persistOrUpdate(Iterable<Entity> entities) {
        MongoOperations.persistOrUpdate(entities);
    }

    default public void persistOrUpdate(Stream<Entity> entities) {
        MongoOperations.persistOrUpdate(entities);
    }

    default public void persistOrUpdate(Entity firstEntity, Entity ... entities) {
        MongoOperations.persistOrUpdate(firstEntity, entities);
    }

    @GenerateBridge
    default public MongoCollection<Entity> mongoCollection() {
        throw MongoOperations.implementationInjectionMissing();
    }

    @GenerateBridge
    default public MongoDatabase mongoDatabase() {
        throw MongoOperations.implementationInjectionMissing();
    }
}

