/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mongodb.panache.runtime;

import com.mongodb.ReadPreference;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Collation;
import io.quarkus.mongodb.panache.PanacheQuery;
import io.quarkus.mongodb.panache.common.runtime.CommonPanacheQueryImpl;
import io.quarkus.panache.common.Page;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.bson.conversions.Bson;

public class PanacheQueryImpl<Entity>
implements PanacheQuery<Entity> {
    private final CommonPanacheQueryImpl<Entity> delegate;

    PanacheQueryImpl(MongoCollection<? extends Entity> collection, ClientSession session, Bson mongoQuery, Bson sort) {
        this.delegate = new CommonPanacheQueryImpl(collection, session, mongoQuery, sort);
    }

    private PanacheQueryImpl(CommonPanacheQueryImpl<Entity> delegate) {
        this.delegate = delegate;
    }

    @Override
    public <T> PanacheQuery<T> project(Class<T> type) {
        return new PanacheQueryImpl<Entity>(this.delegate.project(type));
    }

    @Override
    public <T extends Entity> PanacheQuery<T> page(Page page) {
        this.delegate.page(page);
        return this;
    }

    @Override
    public <T extends Entity> PanacheQuery<T> page(int pageIndex, int pageSize) {
        this.delegate.page(Page.of((int)pageIndex, (int)pageSize));
        return this;
    }

    @Override
    public <T extends Entity> PanacheQuery<T> nextPage() {
        this.delegate.nextPage();
        return this;
    }

    @Override
    public <T extends Entity> PanacheQuery<T> previousPage() {
        this.delegate.previousPage();
        return this;
    }

    @Override
    public <T extends Entity> PanacheQuery<T> firstPage() {
        this.delegate.firstPage();
        return this;
    }

    @Override
    public <T extends Entity> PanacheQuery<T> lastPage() {
        this.delegate.lastPage();
        return this;
    }

    @Override
    public boolean hasNextPage() {
        return this.delegate.hasNextPage();
    }

    @Override
    public boolean hasPreviousPage() {
        return this.delegate.hasPreviousPage();
    }

    @Override
    public int pageCount() {
        return this.delegate.pageCount();
    }

    @Override
    public Page page() {
        return this.delegate.page();
    }

    @Override
    public <T extends Entity> PanacheQuery<T> range(int startIndex, int lastIndex) {
        this.delegate.range(startIndex, lastIndex);
        return this;
    }

    @Override
    public <T extends Entity> PanacheQuery<T> withCollation(Collation collation) {
        this.delegate.withCollation(collation);
        return this;
    }

    @Override
    public <T extends Entity> PanacheQuery<T> withReadPreference(ReadPreference readPreference) {
        this.delegate.withReadPreference(readPreference);
        return this;
    }

    @Override
    public long count() {
        return this.delegate.count();
    }

    @Override
    public <T extends Entity> List<T> list() {
        return this.delegate.list();
    }

    @Override
    public <T extends Entity> Stream<T> stream() {
        return this.delegate.stream();
    }

    @Override
    public <T extends Entity> T firstResult() {
        return (T)this.delegate.firstResult();
    }

    @Override
    public <T extends Entity> Optional<T> firstResultOptional() {
        return this.delegate.firstResultOptional();
    }

    @Override
    public <T extends Entity> T singleResult() {
        return (T)this.delegate.singleResult();
    }

    @Override
    public <T extends Entity> Optional<T> singleResultOptional() {
        return this.delegate.singleResultOptional();
    }
}

