/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.deployment.exporter.otlp;

import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.opentelemetry.deployment.exporter.otlp.ExternalOtelExporterBuildItem;
import io.quarkus.opentelemetry.runtime.config.build.OTelBuildConfig;
import io.quarkus.opentelemetry.runtime.config.build.exporter.OtlpExporterBuildConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.OTelRuntimeConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.exporter.OtlpExporterRuntimeConfig;
import io.quarkus.opentelemetry.runtime.exporter.otlp.LateBoundBatchSpanProcessor;
import io.quarkus.opentelemetry.runtime.exporter.otlp.OTelExporterRecorder;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.quarkus.tls.TlsRegistryBuildItem;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

@BuildSteps(onlyIf={OtlpExporterEnabled.class})
public class OtlpExporterProcessor {
    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=TlsRegistryBuildItem.class)
    void createBatchSpanProcessor(OTelExporterRecorder recorder, OTelRuntimeConfig otelRuntimeConfig, OtlpExporterRuntimeConfig exporterRuntimeConfig, CoreVertxBuildItem vertxBuildItem, List<ExternalOtelExporterBuildItem> externalOtelExporterBuildItem, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        if (!externalOtelExporterBuildItem.isEmpty()) {
            return;
        }
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(LateBoundBatchSpanProcessor.class).types(new Class[]{SpanProcessor.class})).setRuntimeInit().scope(Singleton.class)).unremovable()).addInjectionPoint((Type)ParameterizedType.create((DotName)DotName.createSimple(Instance.class), (Type[])new Type[]{ClassType.create((DotName)DotName.createSimple((String)SpanExporter.class.getName()))}, null), new AnnotationInstance[0])).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(TlsConfigurationRegistry.class)), new AnnotationInstance[0])).createWith(recorder.batchSpanProcessorForOtlp(otelRuntimeConfig, exporterRuntimeConfig, vertxBuildItem.getVertx())).done());
    }

    static class OtlpExporterEnabled
    implements BooleanSupplier {
        OtlpExporterBuildConfig exportBuildConfig;
        OTelBuildConfig otelBuildConfig;

        OtlpExporterEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.otelBuildConfig.enabled() && this.otelBuildConfig.traces().enabled().orElse(Boolean.TRUE) != false && this.otelBuildConfig.traces().exporter().contains("cdi") && this.exportBuildConfig.enabled();
        }
    }
}

