/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.exporter.otlp.runtime.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.MetadataUtils;
import io.quarkus.opentelemetry.exporter.otlp.runtime.graal.Target_io_opentelemetry_exporter_otlp_trace_OtlpGrpcSpanExporter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import javax.net.ssl.SSLException;

@TargetClass(className="io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder")
final class Target_io_opentelemetry_exporter_otlp_trace_OtlpGrpcSpanExporterBuilder {
    @Alias
    private ManagedChannel channel;
    @Alias
    private long timeoutNanos;
    @Alias
    private URI endpoint;
    @Alias
    private Metadata metadata;
    @Alias
    private byte[] trustedCertificatesPem;

    Target_io_opentelemetry_exporter_otlp_trace_OtlpGrpcSpanExporterBuilder() {
    }

    @Substitute
    public Target_io_opentelemetry_exporter_otlp_trace_OtlpGrpcSpanExporter build() {
        if (this.channel == null) {
            ManagedChannelBuilder managedChannelBuilder = ManagedChannelBuilder.forTarget((String)this.endpoint.getAuthority());
            if (this.endpoint.getScheme().equals("https")) {
                managedChannelBuilder.useTransportSecurity();
            } else {
                managedChannelBuilder.usePlaintext();
            }
            if (this.metadata != null) {
                managedChannelBuilder.intercept(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)this.metadata)});
            }
            if (this.trustedCertificatesPem != null) {
                if (managedChannelBuilder.getClass().getName().equals("io.grpc.netty.NettyChannelBuilder")) {
                    NettyChannelBuilder nettyBuilder = (NettyChannelBuilder)managedChannelBuilder;
                    try {
                        nettyBuilder.sslContext(GrpcSslContexts.forClient().trustManager((InputStream)new ByteArrayInputStream(this.trustedCertificatesPem)).build());
                    }
                    catch (IllegalArgumentException | SSLException e) {
                        throw new IllegalStateException("Could not set trusted certificates for gRPC TLS connection, are they valid X.509 in PEM format?", e);
                    }
                } else {
                    throw new IllegalStateException("TLS certificate configuration only supported with Netty. If you need to configure a certificate, switch to grpc-netty or grpc-netty-shaded.");
                }
            }
            this.channel = managedChannelBuilder.build();
        }
        return new Target_io_opentelemetry_exporter_otlp_trace_OtlpGrpcSpanExporter(this.channel, this.timeoutNanos);
    }
}

