/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.IdGenerator;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import io.quarkus.arc.Arc;
import io.quarkus.opentelemetry.runtime.tracing.DelayedAttributes;
import io.quarkus.opentelemetry.runtime.tracing.LateBoundSampler;
import io.quarkus.opentelemetry.runtime.tracing.TracerRuntimeConfig;
import io.quarkus.opentelemetry.runtime.tracing.TracerUtil;
import io.quarkus.opentelemetry.runtime.tracing.vertx.VertxTracingAdapter;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.VertxOptions;
import io.vertx.core.tracing.TracingOptions;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.function.Consumer;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;

@Recorder
public class TracerRecorder {
    static VertxTracingAdapter vertxTracingAdapter = new VertxTracingAdapter();

    public Consumer<VertxOptions> setVertxTracingOptions() {
        return vertxOptions -> vertxOptions.setTracingOptions((TracingOptions)vertxTracingAdapter);
    }

    public RuntimeValue<SdkTracerProvider> createTracerProvider(String quarkusVersion, String serviceName, String serviceVersion, ShutdownContext shutdownContext) {
        BeanManager beanManager = Arc.container().beanManager();
        Instance idGenerator = beanManager.createInstance().select(IdGenerator.class, new Annotation[]{Any.Literal.INSTANCE});
        SdkTracerProviderBuilder builder = SdkTracerProvider.builder();
        if (idGenerator.isResolvable()) {
            builder.setIdGenerator((IdGenerator)idGenerator.get());
        }
        DelayedAttributes delayedAttributes = (DelayedAttributes)beanManager.createInstance().select(DelayedAttributes.class, new Annotation[]{Any.Literal.INSTANCE}).get();
        delayedAttributes.setAttributesDelegate(Resource.getDefault().merge(Resource.create((Attributes)Attributes.of((AttributeKey)ResourceAttributes.SERVICE_NAME, (Object)serviceName, (AttributeKey)ResourceAttributes.SERVICE_VERSION, (Object)serviceVersion, (AttributeKey)ResourceAttributes.WEBENGINE_NAME, (Object)"Quarkus", (AttributeKey)ResourceAttributes.WEBENGINE_VERSION, (Object)quarkusVersion))).getAttributes());
        builder.setResource(Resource.create((Attributes)delayedAttributes));
        LateBoundSampler lateBoundSampler = (LateBoundSampler)beanManager.createInstance().select(LateBoundSampler.class, new Annotation[]{Any.Literal.INSTANCE}).get();
        builder.setSampler((Sampler)lateBoundSampler);
        Instance allExporters = beanManager.createInstance().select(SpanExporter.class, new Annotation[]{Any.Literal.INSTANCE});
        allExporters.forEach(spanExporter -> builder.addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)spanExporter)));
        Instance allProcessors = beanManager.createInstance().select(SpanProcessor.class, new Annotation[]{Any.Literal.INSTANCE});
        allProcessors.forEach(arg_0 -> ((SdkTracerProviderBuilder)builder).addSpanProcessor(arg_0));
        SdkTracerProvider tracerProvider = builder.build();
        shutdownContext.addShutdownTask(() -> {
            tracerProvider.forceFlush();
            tracerProvider.shutdown();
        });
        return new RuntimeValue((Object)tracerProvider);
    }

    public void setupVertxTracer() {
        vertxTracingAdapter.init();
    }

    public void setupResources(TracerRuntimeConfig config) {
        Instance allResources = CDI.current().getBeanManager().createInstance().select(Resource.class, new Annotation[]{Any.Literal.INSTANCE});
        Resource resource = allResources.stream().reduce(Resource.empty(), Resource::merge).merge(config.resourceAttributes.map(TracerUtil::mapResourceAttributes).orElseGet(Resource::empty));
        if (resource.getAttributes().size() > 0) {
            DelayedAttributes delayedAttributes = (DelayedAttributes)CDI.current().select(DelayedAttributes.class, new Annotation[0]).get();
            delayedAttributes.setAttributesDelegate(delayedAttributes.toBuilder().putAll(resource.getAttributes()).build());
        }
    }

    public void setupSampler(TracerRuntimeConfig config) {
        LateBoundSampler lateBoundSampler = (LateBoundSampler)CDI.current().select(LateBoundSampler.class, new Annotation[]{Any.Literal.INSTANCE}).get();
        Optional<Sampler> samplerBean = CDI.current().select(Sampler.class, new Annotation[]{Any.Literal.INSTANCE}).stream().filter(o -> !(o instanceof LateBoundSampler)).findFirst();
        if (samplerBean.isPresent()) {
            lateBoundSampler.setSamplerDelegate(samplerBean.get());
        } else {
            lateBoundSampler.setSamplerDelegate(TracerUtil.mapSampler(config.sampler, config.suppressNonApplicationUris));
        }
    }

    public static boolean isClassPresent(String classname) {
        try {
            Class.forName(classname, false, Thread.currentThread().getContextClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

