/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.restclient;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.io.IOException;
import java.net.URI;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

@Priority(value=3000)
public class ClientTracingFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private static final TextMapPropagator TEXT_MAP_PROPAGATOR = GlobalOpenTelemetry.getPropagators().getTextMapPropagator();
    private static final String SCOPE_KEY = ClientTracingFilter.class.getName() + ".scope";
    private static final String SPAN_KEY = ClientTracingFilter.class.getName() + ".span";
    private final Tracer tracer;
    private static final TextMapSetter<MultivaluedMap<String, Object>> SETTER = new TextMapSetter<MultivaluedMap<String, Object>>(){

        public void set(MultivaluedMap<String, Object> carrier, String key, String value) {
            carrier.add((Object)key, (Object)value);
        }
    };

    public ClientTracingFilter(Tracer tracer) {
        this.tracer = tracer;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        SpanBuilder builder = this.tracer.spanBuilder(this.getSpanName(requestContext)).setSpanKind(SpanKind.CLIENT);
        builder.setAttribute(SemanticAttributes.HTTP_METHOD, (Object)requestContext.getMethod());
        builder.setAttribute(SemanticAttributes.HTTP_URL, (Object)this.filterUserInfo(requestContext.getUri().toString()));
        Span clientSpan = builder.startSpan();
        requestContext.setProperty(SPAN_KEY, (Object)clientSpan);
        requestContext.setProperty(SCOPE_KEY, (Object)clientSpan.makeCurrent());
        TEXT_MAP_PROPAGATOR.inject(Context.current(), (Object)requestContext.getHeaders(), SETTER);
    }

    String filterUserInfo(String httpUrl) {
        if (httpUrl.contains("@")) {
            URI uri = URI.create(httpUrl);
            httpUrl = httpUrl.replace(uri.getUserInfo() + "@", "");
        }
        return httpUrl;
    }

    private String getSpanName(ClientRequestContext requestContext) {
        String uriPath = requestContext.getUri().getPath();
        if (uriPath.length() > 1) {
            return uriPath.substring(1);
        }
        return "HTTP " + requestContext.getMethod();
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        Span clientSpan = (Span)requestContext.getProperty(SPAN_KEY);
        if (clientSpan != null) {
            String pathTemplate = (String)requestContext.getProperty("UrlPathTemplate");
            if (pathTemplate != null && pathTemplate.length() > 1) {
                clientSpan.updateName(pathTemplate.substring(1));
            }
            clientSpan.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, responseContext.getStatus());
            if (!responseContext.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                clientSpan.setStatus(StatusCode.ERROR, responseContext.getStatusInfo().getReasonPhrase());
            }
            clientSpan.end();
            Scope spanScope = (Scope)requestContext.getProperty(SCOPE_KEY);
            if (spanScope != null) {
                spanScope.close();
            }
        }
    }
}

