/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment;

import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.methods.AddMethodImplementor;
import io.quarkus.rest.data.panache.deployment.methods.DeleteMethodImplementor;
import io.quarkus.rest.data.panache.deployment.methods.GetMethodImplementor;
import io.quarkus.rest.data.panache.deployment.methods.ListMethodImplementor;
import io.quarkus.rest.data.panache.deployment.methods.MethodImplementor;
import io.quarkus.rest.data.panache.deployment.methods.UpdateMethodImplementor;
import io.quarkus.rest.data.panache.deployment.methods.hal.AddHalMethodImplementor;
import io.quarkus.rest.data.panache.deployment.methods.hal.GetHalMethodImplementor;
import io.quarkus.rest.data.panache.deployment.methods.hal.ListHalMethodImplementor;
import io.quarkus.rest.data.panache.deployment.methods.hal.UpdateHalMethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import io.quarkus.runtime.util.HashUtil;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Path;
import org.jboss.logging.Logger;

class JaxRsResourceImplementor {
    private static final Logger LOGGER = Logger.getLogger(JaxRsResourceImplementor.class);
    private final List<MethodImplementor> METHOD_IMPLEMENTORS = Arrays.asList(new GetMethodImplementor(), new GetHalMethodImplementor(), new ListMethodImplementor(), new ListHalMethodImplementor(), new AddMethodImplementor(), new AddHalMethodImplementor(), new UpdateMethodImplementor(), new UpdateHalMethodImplementor(), new DeleteMethodImplementor());

    JaxRsResourceImplementor() {
    }

    void implement(ClassOutput classOutput, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties) {
        String controllerClassName = resourceMetadata.getResourceInterface() + "JaxRs_" + HashUtil.sha1((String)resourceMetadata.getResourceInterface());
        LOGGER.tracef("Starting generation of '%s'", (Object)controllerClassName);
        ClassCreator classCreator = ClassCreator.builder().classOutput(classOutput).className(controllerClassName).build();
        this.implementClassAnnotations(classCreator, resourceProperties);
        FieldDescriptor resourceField = this.implementResourceField(classCreator, resourceMetadata);
        this.implementMethods(classCreator, resourceMetadata, resourceProperties, resourceField);
        classCreator.close();
        LOGGER.tracef("Completed generation of '%s'", (Object)controllerClassName);
    }

    private void implementClassAnnotations(ClassCreator classCreator, ResourceProperties resourceProperties) {
        classCreator.addAnnotation(Path.class).addValue("value", (Object)resourceProperties.getPath());
    }

    private FieldDescriptor implementResourceField(ClassCreator classCreator, ResourceMetadata resourceMetadata) {
        FieldCreator resourceFieldCreator = classCreator.getFieldCreator("resource", resourceMetadata.getResourceClass());
        resourceFieldCreator.addAnnotation(Inject.class);
        return resourceFieldCreator.getFieldDescriptor();
    }

    private void implementMethods(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceField) {
        for (MethodImplementor methodImplementor : this.METHOD_IMPLEMENTORS) {
            methodImplementor.implement(classCreator, resourceMetadata, resourceProperties, resourceField);
        }
    }
}

