/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.methods;

import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.panache.common.Page;
import io.quarkus.panache.common.Sort;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.methods.StandardMethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import io.quarkus.rest.data.panache.deployment.utils.PaginationImplementor;
import io.quarkus.rest.data.panache.deployment.utils.ResponseImplementor;
import io.quarkus.rest.data.panache.deployment.utils.SortImplementor;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

public final class ListMethodImplementor
extends StandardMethodImplementor {
    private static final String METHOD_NAME = "list";
    private static final String RESOURCE_METHOD_NAME = "list";
    private static final String REL = "list";
    private final PaginationImplementor paginationImplementor = new PaginationImplementor();
    private final SortImplementor sortImplementor = new SortImplementor();

    @Override
    protected void implementInternal(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceField) {
        if (resourceProperties.isPaged()) {
            this.implementPaged(classCreator, resourceMetadata, resourceProperties, resourceField);
        } else {
            this.implementNotPaged(classCreator, resourceMetadata, resourceProperties, resourceField);
        }
    }

    @Override
    protected String getResourceMethodName() {
        return "list";
    }

    private void implementPaged(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceField) {
        MethodCreator methodCreator = classCreator.getMethodCreator("list", Response.class, new Class[]{List.class, Integer.TYPE, Integer.TYPE, UriInfo.class});
        this.addGetAnnotation((AnnotatedElement)methodCreator);
        this.addPathAnnotation((AnnotatedElement)methodCreator, resourceProperties.getMethodPath("list"));
        this.addProducesAnnotation((AnnotatedElement)methodCreator, "application/json");
        this.addLinksAnnotation((AnnotatedElement)methodCreator, resourceMetadata.getEntityType(), "list");
        this.addQueryParamAnnotation(methodCreator.getParameterAnnotations(0), "sort");
        this.addQueryParamAnnotation(methodCreator.getParameterAnnotations(1), "page");
        this.addDefaultValueAnnotation(methodCreator.getParameterAnnotations(1), Integer.toString(0));
        this.addQueryParamAnnotation(methodCreator.getParameterAnnotations(2), "size");
        this.addDefaultValueAnnotation(methodCreator.getParameterAnnotations(2), Integer.toString(20));
        this.addContextAnnotation(methodCreator.getParameterAnnotations(3));
        ResultHandle resource = methodCreator.readInstanceField(resourceField, methodCreator.getThis());
        ResultHandle sortQuery = methodCreator.getMethodParam(0);
        ResultHandle sort = this.sortImplementor.getSort((BytecodeCreator)methodCreator, sortQuery);
        ResultHandle pageIndex = methodCreator.getMethodParam(1);
        ResultHandle pageSize = methodCreator.getMethodParam(2);
        ResultHandle page = this.paginationImplementor.getPage((BytecodeCreator)methodCreator, pageIndex, pageSize);
        ResultHandle pageCount = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)"$$_page_count_list", Integer.TYPE, (Object[])new Object[]{Page.class}), resource, new ResultHandle[]{page});
        ResultHandle uriInfo = methodCreator.getMethodParam(3);
        ResultHandle links = this.paginationImplementor.getLinks((BytecodeCreator)methodCreator, uriInfo, page, pageCount);
        ResultHandle entities = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)"list", List.class, (Object[])new Object[]{Page.class, Sort.class}), resource, new ResultHandle[]{page, sort});
        methodCreator.returnValue(ResponseImplementor.ok((BytecodeCreator)methodCreator, entities, links));
        methodCreator.close();
    }

    private void implementNotPaged(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceFieldDescriptor) {
        MethodCreator methodCreator = classCreator.getMethodCreator("list", Response.class, new Class[]{List.class});
        this.addGetAnnotation((AnnotatedElement)methodCreator);
        this.addPathAnnotation((AnnotatedElement)methodCreator, resourceProperties.getMethodPath("list"));
        this.addProducesAnnotation((AnnotatedElement)methodCreator, "application/json");
        this.addLinksAnnotation((AnnotatedElement)methodCreator, resourceMetadata.getEntityType(), "list");
        this.addQueryParamAnnotation(methodCreator.getParameterAnnotations(0), "sort");
        ResultHandle sortQuery = methodCreator.getMethodParam(0);
        ResultHandle sort = this.sortImplementor.getSort((BytecodeCreator)methodCreator, sortQuery);
        ResultHandle resource = methodCreator.readInstanceField(resourceFieldDescriptor, methodCreator.getThis());
        ResultHandle entities = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)resourceMetadata.getResourceClass(), (String)"list", List.class, (Object[])new Object[]{Page.class, Sort.class}), resource, new ResultHandle[]{methodCreator.loadNull(), sort});
        methodCreator.returnValue(ResponseImplementor.ok((BytecodeCreator)methodCreator, entities));
        methodCreator.close();
    }
}

