/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.methods;

import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.AnnotationCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.methods.MethodImplementor;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import javax.transaction.Transactional;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.links.LinkResource;

public abstract class StandardMethodImplementor
implements MethodImplementor {
    @Override
    public void implement(ClassCreator classCreator, ResourceMetadata resourceMetadata, ResourceProperties resourceProperties, FieldDescriptor resourceField) {
        if (resourceProperties.isExposed(this.getResourceMethodName())) {
            this.implementInternal(classCreator, resourceMetadata, resourceProperties, resourceField);
        }
    }

    protected abstract void implementInternal(ClassCreator var1, ResourceMetadata var2, ResourceProperties var3, FieldDescriptor var4);

    protected abstract String getResourceMethodName();

    protected void addTransactionalAnnotation(AnnotatedElement element) {
        element.addAnnotation(Transactional.class);
    }

    protected void addGetAnnotation(AnnotatedElement element) {
        element.addAnnotation(GET.class);
    }

    protected void addPostAnnotation(AnnotatedElement element) {
        element.addAnnotation(POST.class);
    }

    protected void addPutAnnotation(AnnotatedElement element) {
        element.addAnnotation(PUT.class);
    }

    protected void addDeleteAnnotation(AnnotatedElement element) {
        element.addAnnotation(DELETE.class);
    }

    protected void addLinksAnnotation(AnnotatedElement element, String entityClassName, String rel) {
        AnnotationCreator linkResource = element.addAnnotation(LinkResource.class);
        linkResource.addValue("entityClassName", (Object)entityClassName);
        linkResource.addValue("rel", (Object)rel);
    }

    protected void addPathAnnotation(AnnotatedElement element, String value) {
        element.addAnnotation(Path.class).addValue("value", (Object)value);
    }

    protected void addPathParamAnnotation(AnnotatedElement element, String value) {
        element.addAnnotation(PathParam.class).addValue("value", (Object)value);
    }

    protected void addQueryParamAnnotation(AnnotatedElement element, String value) {
        element.addAnnotation(QueryParam.class).addValue("value", (Object)value);
    }

    protected void addDefaultValueAnnotation(AnnotatedElement element, String value) {
        element.addAnnotation(DefaultValue.class).addValue("value", (Object)value);
    }

    protected void addProducesAnnotation(AnnotatedElement element, String ... mediaTypes) {
        element.addAnnotation(Produces.class).addValue("value", (Object)mediaTypes);
    }

    protected void addConsumesAnnotation(AnnotatedElement element, String ... mediaTypes) {
        element.addAnnotation(Consumes.class).addValue("value", (Object)mediaTypes);
    }

    protected void addContextAnnotation(AnnotatedElement element) {
        element.addAnnotation(Context.class);
    }

    protected String appendToPath(String path, String suffix) {
        if (path.endsWith("/")) {
            path = path.substring(0, path.lastIndexOf("/"));
        }
        if (suffix.startsWith("/")) {
            suffix = suffix.substring(1);
        }
        return String.join((CharSequence)"/", path, suffix);
    }
}

