/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.data.panache.deployment.properties;

import io.quarkus.rest.data.panache.MethodProperties;
import io.quarkus.rest.data.panache.deployment.properties.ResourceProperties;
import io.quarkus.rest.data.panache.deployment.utils.ResourceName;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;

public class ResourcePropertiesProvider {
    private static final DotName RESOURCE_PROPERTIES_ANNOTATION = DotName.createSimple((String)io.quarkus.rest.data.panache.ResourceProperties.class.getName());
    private static final DotName METHOD_PROPERTIES_ANNOTATION = DotName.createSimple((String)MethodProperties.class.getName());
    private final IndexView index;

    public ResourcePropertiesProvider(IndexView index) {
        this.index = index;
    }

    public ResourceProperties getForInterface(String resourceInterface) {
        DotName resourceInterfaceName = DotName.createSimple((String)resourceInterface);
        AnnotationInstance annotation = this.findResourcePropertiesAnnotation(resourceInterfaceName);
        return new ResourceProperties(this.isHal(annotation), this.getPath(annotation, resourceInterface), this.isPaged(annotation), this.getMethodPropertiesInfoMap(resourceInterfaceName));
    }

    private AnnotationInstance findResourcePropertiesAnnotation(DotName className) {
        ClassInfo classInfo = this.index.getClassByName(className);
        if (classInfo == null) {
            return null;
        }
        if (classInfo.classAnnotation(RESOURCE_PROPERTIES_ANNOTATION) != null) {
            return classInfo.classAnnotation(RESOURCE_PROPERTIES_ANNOTATION);
        }
        if (classInfo.superName() != null) {
            return this.findResourcePropertiesAnnotation(classInfo.superName());
        }
        return null;
    }

    private Map<String, io.quarkus.rest.data.panache.deployment.properties.MethodProperties> getMethodPropertiesInfoMap(DotName className) {
        HashSet<String> methodNames = new HashSet<String>();
        HashMap<String, AnnotationInstance> annotations = new HashMap<String, AnnotationInstance>();
        this.collectMethods(className, methodNames, annotations);
        HashMap<String, io.quarkus.rest.data.panache.deployment.properties.MethodProperties> methodPropertiesInfoMap = new HashMap<String, io.quarkus.rest.data.panache.deployment.properties.MethodProperties>();
        for (String methodName : methodNames) {
            methodPropertiesInfoMap.put(methodName, this.getMethodPropertiesInfo((AnnotationInstance)annotations.get(methodName)));
        }
        return methodPropertiesInfoMap;
    }

    private void collectMethods(DotName className, Set<String> methodNames, Map<String, AnnotationInstance> annotations) {
        ClassInfo classInfo = this.index.getClassByName(className);
        if (classInfo == null) {
            return;
        }
        for (MethodInfo method : classInfo.methods()) {
            if (method.hasAnnotation(METHOD_PROPERTIES_ANNOTATION)) {
                annotations.putIfAbsent(method.name(), method.annotation(METHOD_PROPERTIES_ANNOTATION));
            }
            methodNames.add(method.name());
        }
        if (classInfo.superName() != null) {
            this.collectMethods(classInfo.superName(), methodNames, annotations);
        }
    }

    private io.quarkus.rest.data.panache.deployment.properties.MethodProperties getMethodPropertiesInfo(AnnotationInstance annotation) {
        return new io.quarkus.rest.data.panache.deployment.properties.MethodProperties(this.isExposed(annotation), this.getPath(annotation));
    }

    private boolean isHal(AnnotationInstance annotation) {
        return annotation != null && annotation.value("hal") != null && annotation.value("hal").asBoolean();
    }

    private boolean isPaged(AnnotationInstance annotation) {
        return annotation == null || annotation.value("paged") == null || annotation.value("paged").asBoolean();
    }

    private boolean isExposed(AnnotationInstance annotation) {
        return annotation == null || annotation.value("exposed") == null || annotation.value("exposed").asBoolean();
    }

    private String getPath(AnnotationInstance annotation) {
        if (annotation != null && annotation.value("path") != null) {
            return annotation.value("path").asString();
        }
        return "";
    }

    private String getPath(AnnotationInstance annotation, String resourceInterface) {
        if (annotation != null && annotation.value("path") != null) {
            return annotation.value("path").asString();
        }
        return ResourceName.fromClass(resourceInterface);
    }
}

