/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.jsonb.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.jsonb.runtime.QuarkusJsonbContextResolver;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.json.bind.Jsonb;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class ResteasyJsonbProcessor {
    private static final DotName JSONB = DotName.createSimple((String)Jsonb.class.getName());

    @BuildStep
    CapabilityBuildItem capability() {
        return new CapabilityBuildItem("io.quarkus.resteasy-json");
    }

    @BuildStep
    void build(BuildProducer<FeatureBuildItem> feature) {
        feature.produce((BuildItem)new FeatureBuildItem("resteasy-jsonb"));
    }

    @BuildStep
    void register(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ResteasyJaxrsProviderBuildItem> jaxrsProvider, BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<UnremovableBeanBuildItem> unremovable) {
        IndexView index = combinedIndexBuildItem.getIndex();
        jaxrsProvider.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(QuarkusJsonbContextResolver.class.getName()));
        additionalBean.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(QuarkusJsonbContextResolver.class));
        Set<String> userSuppliedProducers = this.getUserSuppliedJsonbProducerBeans(index);
        if (!userSuppliedProducers.isEmpty()) {
            unremovable.produce((BuildItem)new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassNamesExclusion(userSuppliedProducers)));
        }
    }

    private Set<String> getUserSuppliedJsonbProducerBeans(IndexView index) {
        HashSet<String> result = new HashSet<String>();
        for (AnnotationInstance annotation : index.getAnnotations(DotNames.PRODUCES)) {
            if (annotation.target().kind() != AnnotationTarget.Kind.METHOD || !JSONB.equals((Object)annotation.target().asMethod().returnType().name())) continue;
            result.add(annotation.target().asMethod().declaringClass().name().toString());
        }
        return result;
    }
}

