/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime;

import io.quarkus.vertx.http.runtime.VertxInputStream;
import io.vertx.ext.web.RoutingContext;
import java.io.InputStream;
import java.time.Duration;
import org.jboss.resteasy.reactive.common.util.EmptyInputStream;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.RuntimeConfigurableServerRestHandler;
import org.jboss.resteasy.reactive.server.spi.RuntimeConfiguration;
import org.jboss.resteasy.reactive.server.vertx.VertxResteasyReactiveRequestContext;

public class BlockingInputHandler
implements RuntimeConfigurableServerRestHandler {
    private volatile Duration timeout;

    public void configure(RuntimeConfiguration configuration) {
        this.timeout = configuration.readTimeout();
    }

    public void handle(ResteasyReactiveRequestContext context) throws Exception {
        if (context.getInputStream() != EmptyInputStream.INSTANCE) {
            return;
        }
        if (context.serverRequest().getRequestMethod().equals("GET") || context.serverRequest().getRequestMethod().equals("HEAD")) {
            return;
        }
        if (context instanceof VertxResteasyReactiveRequestContext) {
            VertxResteasyReactiveRequestContext vertxContext = (VertxResteasyReactiveRequestContext)context;
            RoutingContext routingContext = vertxContext.getContext();
            vertxContext.setInputStream((InputStream)new VertxInputStream(routingContext, this.timeout.toMillis()));
        }
    }
}

