/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime;

import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveServerRuntimeConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.MemorySize;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.spi.RuntimeConfigurableServerRestHandler;
import org.jboss.resteasy.reactive.server.spi.RuntimeConfiguration;

@Recorder
public class ResteasyReactiveRuntimeRecorder {
    final HttpConfiguration httpConf;

    public ResteasyReactiveRuntimeRecorder(HttpConfiguration httpConf) {
        this.httpConf = httpConf;
    }

    public void configure(RuntimeValue<Deployment> deployment, final ResteasyReactiveServerRuntimeConfig runtimeConf) {
        List runtimeConfigurableServerRestHandlers = ((Deployment)deployment.getValue()).getRuntimeConfigurableServerRestHandlers();
        for (RuntimeConfigurableServerRestHandler handler : runtimeConfigurableServerRestHandlers) {
            handler.configure(new RuntimeConfiguration(){

                public Duration readTimeout() {
                    return ResteasyReactiveRuntimeRecorder.this.httpConf.readTimeout;
                }

                public RuntimeConfiguration.Body body() {
                    return new RuntimeConfiguration.Body(){

                        public boolean deleteUploadedFilesOnEnd() {
                            return ResteasyReactiveRuntimeRecorder.this.httpConf.body.deleteUploadedFilesOnEnd;
                        }

                        public String uploadsDirectory() {
                            return ResteasyReactiveRuntimeRecorder.this.httpConf.body.uploadsDirectory;
                        }

                        public Charset defaultCharset() {
                            return runtimeConf.multipart.inputPart.defaultCharset;
                        }
                    };
                }

                public RuntimeConfiguration.Limits limits() {
                    return new RuntimeConfiguration.Limits(){

                        public Optional<Long> maxBodySize() {
                            if (ResteasyReactiveRuntimeRecorder.this.httpConf.limits.maxBodySize.isPresent()) {
                                return Optional.of(((MemorySize)ResteasyReactiveRuntimeRecorder.this.httpConf.limits.maxBodySize.get()).asLongValue());
                            }
                            return Optional.empty();
                        }

                        public long maxFormAttributeSize() {
                            return ResteasyReactiveRuntimeRecorder.this.httpConf.limits.maxFormAttributeSize.asLongValue();
                        }
                    };
                }
            });
        }
    }
}

