/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime.standalone;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.resteasy.runtime.standalone.BufferAllocator;
import io.quarkus.resteasy.runtime.standalone.VertxRequestHandler;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.http.runtime.ThreadLocalHandler;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.StaticHandler;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.resteasy.spi.ResteasyDeployment;

@Recorder
public class ResteasyStandaloneRecorder {
    public static final String META_INF_RESOURCES = "META-INF/resources";
    protected static final int BUFFER_SIZE = 8192;
    private static boolean useDirect = true;
    private static BufferAllocator ALLOCATOR = new BufferAllocator(){

        @Override
        public ByteBuf allocateBuffer() {
            return this.allocateBuffer(useDirect);
        }

        @Override
        public ByteBuf allocateBuffer(boolean direct) {
            return this.allocateBuffer(direct, 8192);
        }

        @Override
        public ByteBuf allocateBuffer(int bufferSize) {
            return this.allocateBuffer(useDirect, bufferSize);
        }

        @Override
        public ByteBuf allocateBuffer(boolean direct, int bufferSize) {
            if (direct) {
                return PooledByteBufAllocator.DEFAULT.directBuffer(bufferSize);
            }
            return PooledByteBufAllocator.DEFAULT.heapBuffer(bufferSize);
        }

        @Override
        public int getBufferSize() {
            return 8192;
        }
    };
    private static volatile List<Path> hotDeploymentResourcePaths;
    private static ResteasyDeployment deployment;
    private static Set<String> knownPaths;
    private static String contextPath;

    public static void setHotDeploymentResources(List<Path> resources) {
        hotDeploymentResourcePaths = resources;
    }

    public void staticInit(ResteasyDeployment dep, String path, Set<String> known) {
        if (dep != null) {
            deployment = dep;
            deployment.start();
        }
        knownPaths = known;
        contextPath = path;
    }

    public Consumer<Route> start(Supplier<Vertx> vertx, ShutdownContext shutdown, BeanContainer beanContainer, boolean isVirtual, boolean isDefaultResourcesPath, Executor executor) {
        shutdown.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                if (deployment != null) {
                    deployment.stop();
                }
            }
        });
        useDirect = !isVirtual;
        final ArrayList<Object> handlers = new ArrayList<Object>();
        if (hotDeploymentResourcePaths != null && !hotDeploymentResourcePaths.isEmpty()) {
            for (Path resourcePath : hotDeploymentResourcePaths) {
                final String root = resourcePath.toAbsolutePath().toString();
                ThreadLocalHandler staticHandler = new ThreadLocalHandler((Supplier)new Supplier<Handler<RoutingContext>>(){

                    @Override
                    public Handler<RoutingContext> get() {
                        StaticHandler staticHandler = StaticHandler.create();
                        staticHandler.setCachingEnabled(false);
                        staticHandler.setAllowRootFileSystemAccess(true);
                        staticHandler.setWebRoot(root);
                        staticHandler.setDefaultContentEncoding("UTF-8");
                        return staticHandler;
                    }
                });
                handlers.add(event -> {
                    try {
                        staticHandler.handle(event);
                    }
                    catch (Exception e) {
                        event.next();
                    }
                });
            }
        }
        if (!knownPaths.isEmpty()) {
            ThreadLocalHandler staticHandler = new ThreadLocalHandler((Supplier)new Supplier<Handler<RoutingContext>>(){

                @Override
                public Handler<RoutingContext> get() {
                    return StaticHandler.create((String)ResteasyStandaloneRecorder.META_INF_RESOURCES).setDefaultContentEncoding("UTF-8");
                }
            });
            handlers.add(ctx -> {
                String rel;
                String string = rel = ctx.mountPoint() == null ? ctx.normalisedPath() : ctx.normalisedPath().substring(ctx.mountPoint().length());
                if (knownPaths.contains(rel)) {
                    staticHandler.handle(ctx);
                } else {
                    ctx.next();
                }
            });
        }
        if (deployment != null && isDefaultResourcesPath) {
            handlers.add(this.vertxRequestHandler(vertx, beanContainer, executor));
        }
        return new Consumer<Route>(){

            @Override
            public void accept(Route route) {
                for (Handler i : handlers) {
                    route.handler(i);
                }
            }
        };
    }

    public Handler<RoutingContext> vertxRequestHandler(Supplier<Vertx> vertx, BeanContainer beanContainer, Executor executor) {
        if (deployment != null) {
            return new VertxRequestHandler(vertx.get(), beanContainer, deployment, contextPath, ALLOCATOR, executor);
        }
        return null;
    }
}

