/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLExecutionHandler;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLNotFoundHandler;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLRuntimeConfig;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLSchemaHandler;
import io.quarkus.smallrye.graphql.runtime.SmallRyeGraphQLStaticHandler;
import io.quarkus.smallrye.graphql.runtime.spi.QuarkusClassloadingService;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.smallrye.graphql.cdi.config.GraphQLConfig;
import io.smallrye.graphql.cdi.producer.GraphQLProducer;
import io.smallrye.graphql.schema.model.Schema;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;

@Recorder
public class SmallRyeGraphQLRecorder {
    public void createExecutionService(BeanContainer beanContainer, Schema schema) {
        GraphQLProducer graphQLProducer = (GraphQLProducer)beanContainer.instance(GraphQLProducer.class, new Annotation[0]);
        GraphQLConfig graphQLConfig = (GraphQLConfig)beanContainer.instance(GraphQLConfig.class, new Annotation[0]);
        graphQLProducer.initialize(schema, graphQLConfig);
    }

    public Handler<RoutingContext> executionHandler(boolean allowGet) {
        Instance identityAssociations = CDI.current().select(CurrentIdentityAssociation.class, new Annotation[0]);
        CurrentIdentityAssociation association = identityAssociations.isResolvable() ? (CurrentIdentityAssociation)identityAssociations.get() : null;
        CurrentVertxRequest currentVertxRequest = (CurrentVertxRequest)CDI.current().select(CurrentVertxRequest.class, new Annotation[0]).get();
        return new SmallRyeGraphQLExecutionHandler(allowGet, association, currentVertxRequest);
    }

    public Handler<RoutingContext> schemaHandler() {
        return new SmallRyeGraphQLSchemaHandler();
    }

    public Handler<RoutingContext> uiHandler(String graphqlUiFinalDestination, String graphqlUiPath, SmallRyeGraphQLRuntimeConfig runtimeConfig) {
        if (runtimeConfig.enable) {
            return new SmallRyeGraphQLStaticHandler(graphqlUiFinalDestination, graphqlUiPath);
        }
        return new SmallRyeGraphQLNotFoundHandler();
    }

    public void setupClDevMode(ShutdownContext shutdownContext) {
        QuarkusClassloadingService.setClassLoader(Thread.currentThread().getContextClassLoader());
        shutdownContext.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                QuarkusClassloadingService.setClassLoader(null);
            }
        });
    }
}

