/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.graphql.runtime;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.StaticHandler;

public class SmallRyeGraphQLStaticHandler
implements Handler<RoutingContext> {
    private String graphqlUiFinalDestination;
    private String graphqlUiPath;

    public SmallRyeGraphQLStaticHandler() {
    }

    public SmallRyeGraphQLStaticHandler(String graphqlUiFinalDestination, String graphqlUiPath) {
        this.graphqlUiFinalDestination = graphqlUiFinalDestination;
        this.graphqlUiPath = graphqlUiPath;
    }

    public String getGraphqlUiFinalDestination() {
        return this.graphqlUiFinalDestination;
    }

    public void setGraphqlUiFinalDestination(String graphqlUiFinalDestination) {
        this.graphqlUiFinalDestination = graphqlUiFinalDestination;
    }

    public String getGraphqlUiPath() {
        return this.graphqlUiPath;
    }

    public void setGraphqlUiPath(String graphqlUiPath) {
        this.graphqlUiPath = graphqlUiPath;
    }

    public void handle(RoutingContext event) {
        StaticHandler staticHandler = StaticHandler.create().setAllowRootFileSystemAccess(true).setWebRoot(this.graphqlUiFinalDestination).setDefaultContentEncoding("UTF-8");
        if (event.normalisedPath().length() == this.graphqlUiPath.length()) {
            event.response().setStatusCode(302);
            event.response().headers().set(HttpHeaders.LOCATION, (CharSequence)(this.graphqlUiPath + "/"));
            event.response().end();
            return;
        }
        if (event.normalisedPath().length() == this.graphqlUiPath.length() + 1) {
            event.reroute(this.graphqlUiPath + "/index.html");
            return;
        }
        staticHandler.handle((Object)event);
    }
}

