/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.jwt.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.processor.BeanConfigurator;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.security.deployment.JCAProviderBuildItem;
import io.quarkus.smallrye.jwt.deployment.SmallRyeJwtBuildTimeConfig;
import io.quarkus.smallrye.jwt.runtime.auth.JWTAuthMechanism;
import io.quarkus.smallrye.jwt.runtime.auth.JsonWebTokenCredentialProducer;
import io.quarkus.smallrye.jwt.runtime.auth.JwtPrincipalProducer;
import io.quarkus.smallrye.jwt.runtime.auth.MpJwtValidator;
import io.quarkus.smallrye.jwt.runtime.auth.RawOptionalClaimCreator;
import io.quarkus.vertx.http.deployment.SecurityInformationBuildItem;
import io.smallrye.jwt.algorithm.KeyEncryptionAlgorithm;
import io.smallrye.jwt.algorithm.SignatureAlgorithm;
import io.smallrye.jwt.auth.cdi.ClaimValueProducer;
import io.smallrye.jwt.auth.cdi.CommonJwtProducer;
import io.smallrye.jwt.auth.cdi.JWTCallerPrincipalFactoryProducer;
import io.smallrye.jwt.auth.cdi.JsonValueProducer;
import io.smallrye.jwt.auth.cdi.RawClaimTypeProducer;
import io.smallrye.jwt.auth.principal.DefaultJWTParser;
import io.smallrye.jwt.config.JWTAuthContextInfoProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class SmallRyeJwtProcessor {
    private static final Logger log = Logger.getLogger((String)SmallRyeJwtProcessor.class.getName());
    private static final String MP_JWT_VERIFY_KEY_LOCATION = "mp.jwt.verify.publickey.location";
    private static final String MP_JWT_DECRYPT_KEY_LOCATION = "mp.jwt.decrypt.key.location";
    private static final DotName CLAIM_NAME = DotName.createSimple((String)Claim.class.getName());
    private static final DotName CLAIMS_NAME = DotName.createSimple((String)Claims.class.getName());
    SmallRyeJwtBuildTimeConfig config;

    SmallRyeJwtProcessor() {
    }

    @BuildStep(onlyIf={IsEnabled.class})
    ExtensionSslNativeSupportBuildItem enableSslInNative() {
        return new ExtensionSslNativeSupportBuildItem(Feature.SMALLRYE_JWT);
    }

    @BuildStep(onlyIf={IsEnabled.class})
    public void provideSecurityInformation(BuildProducer<SecurityInformationBuildItem> securityInformationProducer) {
        securityInformationProducer.produce((BuildItem)SecurityInformationBuildItem.JWT());
    }

    @BuildStep
    void registerAdditionalBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        if (this.config.enabled) {
            AdditionalBeanBuildItem.Builder unremovable = AdditionalBeanBuildItem.builder().setUnremovable();
            unremovable.addBeanClass(MpJwtValidator.class);
            unremovable.addBeanClass(JsonWebTokenCredentialProducer.class);
            unremovable.addBeanClass(JWTAuthMechanism.class);
            unremovable.addBeanClass(ClaimValueProducer.class);
            additionalBeans.produce((BuildItem)unremovable.build());
        }
        AdditionalBeanBuildItem.Builder removable = AdditionalBeanBuildItem.builder();
        removable.addBeanClass(JWTAuthContextInfoProvider.class);
        removable.addBeanClass(DefaultJWTParser.class);
        removable.addBeanClass(CommonJwtProducer.class);
        removable.addBeanClass(RawClaimTypeProducer.class);
        removable.addBeanClass(JsonValueProducer.class);
        removable.addBeanClass(JwtPrincipalProducer.class);
        removable.addBeanClass(JWTCallerPrincipalFactoryProducer.class);
        removable.addBeanClass(Claim.class);
        additionalBeans.produce((BuildItem)removable.build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{SignatureAlgorithm.class}).methods().fields().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{KeyEncryptionAlgorithm.class}).methods().fields().build());
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.SMALLRYE_JWT);
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    void registerNativeImageResources(BuildProducer<NativeImageResourceBuildItem> nativeImageResource) {
        Config config = ConfigProvider.getConfig();
        this.registerKeyLocationResource(config, MP_JWT_VERIFY_KEY_LOCATION, nativeImageResource);
        this.registerKeyLocationResource(config, MP_JWT_DECRYPT_KEY_LOCATION, nativeImageResource);
    }

    private void registerKeyLocationResource(Config config, String propertyName, BuildProducer<NativeImageResourceBuildItem> nativeImageResource) {
        Optional keyLocation = config.getOptionalValue(propertyName, String.class);
        if (keyLocation.isPresent() && ((String)keyLocation.get()).length() > 1 && (((String)keyLocation.get()).indexOf(58) < 0 || ((String)keyLocation.get()).startsWith("classpath:"))) {
            log.infof("Adding %s to native image", keyLocation.get());
            String location = ((String)keyLocation.get()).startsWith("/") ? ((String)keyLocation.get()).substring(1) : (String)keyLocation.get();
            nativeImageResource.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{location}));
        }
    }

    @BuildStep
    JCAProviderBuildItem registerRSASigProvider() {
        return new JCAProviderBuildItem(this.config.rsaSigProvider);
    }

    @BuildStep
    void registerOptionalClaimProducer(BeanRegistrationPhaseBuildItem beanRegistrationPhase, BuildProducer<BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem> beanConfigurator) {
        HashSet<Type> additionalTypes = new HashSet<Type>();
        for (InjectionPointInfo injectionPoint : (Collection)beanRegistrationPhase.getContext().get(BuildExtension.Key.INJECTION_POINTS)) {
            Type actualType;
            AnnotationInstance claimQualifier;
            if (injectionPoint.hasDefaultedQualifier() || (claimQualifier = injectionPoint.getRequiredQualifier(CLAIM_NAME)) == null || !injectionPoint.getType().name().equals((Object)DotNames.PROVIDER) || !(actualType = injectionPoint.getRequiredType()).name().equals((Object)DotNames.OPTIONAL) || actualType.name().toString().startsWith("jakarta.json")) continue;
            additionalTypes.add(actualType);
        }
        BeanConfigurator configurator = beanRegistrationPhase.getContext().configure(Optional.class);
        for (Type type : additionalTypes) {
            configurator.addType(type);
        }
        configurator.scope(BuiltinScope.DEPENDENT.getInfo());
        configurator.qualifiers(new AnnotationInstance[]{AnnotationInstance.create((DotName)CLAIM_NAME, null, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)""), AnnotationValue.createEnumValue((String)"standard", (DotName)CLAIMS_NAME, (String)"UNKNOWN")})});
        configurator.creator(RawOptionalClaimCreator.class);
        beanConfigurator.produce((BuildItem)new BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem(new BeanConfigurator[]{configurator}));
    }

    public static class IsEnabled
    implements BooleanSupplier {
        SmallRyeJwtBuildTimeConfig config;

        @Override
        public boolean getAsBoolean() {
            return this.config.enabled;
        }
    }
}

