/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.test.common.ArtifactLauncher;
import io.quarkus.test.common.DockerContainerArtifactLauncher;
import io.quarkus.test.common.IntegrationTestStartedNotifier;
import io.quarkus.test.common.LauncherUtil;
import io.quarkus.test.common.ListeningAddress;
import io.quarkus.test.common.PropertyTestUtil;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class DefaultDockerContainerLauncher
implements DockerContainerArtifactLauncher {
    private Process quarkusProcess;
    private int httpPort;
    private int httpsPort;
    private long waitTimeSeconds;
    private String testProfile;
    private List<String> argLine;
    private ArtifactLauncher.InitContext.DevServicesLaunchResult devServicesLaunchResult;
    private String containerImage;
    private boolean pullRequired;
    private final Map<String, String> systemProps = new HashMap<String, String>();
    private boolean isSsl;

    @Override
    public void init(DockerContainerArtifactLauncher.DockerInitContext initContext) {
        this.httpPort = initContext.httpPort();
        this.httpsPort = initContext.httpsPort();
        this.waitTimeSeconds = initContext.waitTime().getSeconds();
        this.testProfile = initContext.testProfile();
        this.argLine = initContext.argLine();
        this.devServicesLaunchResult = initContext.getDevServicesLaunchResult();
        this.containerImage = initContext.containerImage();
        this.pullRequired = initContext.pullRequired();
    }

    @Override
    public void start() throws IOException {
        if (this.pullRequired) {
            System.out.println("Pulling container image '" + this.containerImage + "'");
            try {
                int pullResult = new ProcessBuilder(new String[0]).redirectError(ProcessBuilder.Redirect.DISCARD).redirectOutput(ProcessBuilder.Redirect.DISCARD).command(List.of("docker", "pull", this.containerImage).toArray(new String[0])).start().waitFor();
                if (pullResult > 0) {
                    throw new RuntimeException("Pulling container image '" + this.containerImage + "' completed unsuccessfully");
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Unable to pull container image '" + this.containerImage + "'", e);
            }
        }
        System.setProperty("test.url", TestHTTPResourceManager.getUri());
        if (this.httpPort == 0) {
            this.httpPort = this.getRandomPort();
        }
        if (this.httpsPort == 0) {
            this.httpsPort = this.getRandomPort();
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add("docker");
        args.add("run");
        if (!this.argLine.isEmpty()) {
            args.addAll(this.argLine);
        }
        args.add("--rm");
        args.add("-p");
        args.add(this.httpPort + ":" + this.httpPort);
        args.add("-p");
        args.add(this.httpsPort + ":" + this.httpsPort);
        if (this.devServicesLaunchResult.networkId() != null) {
            args.add("--net=" + this.devServicesLaunchResult.networkId());
        }
        args.addAll(this.toEnvVar("quarkus.http.port", "" + this.httpPort));
        args.addAll(this.toEnvVar("quarkus.http.ssl-port", "" + this.httpsPort));
        args.addAll(this.toEnvVar("test.url", TestHTTPResourceManager.getUri()));
        if (this.testProfile != null) {
            args.addAll(this.toEnvVar("quarkus.profile", this.testProfile));
        }
        for (Map.Entry<String, String> e : this.systemProps.entrySet()) {
            args.addAll(this.toEnvVar(e.getKey(), e.getValue()));
        }
        args.add(this.containerImage);
        Path logFile = PropertyTestUtil.getLogFilePath();
        Files.deleteIfExists(logFile);
        Files.createDirectories(logFile.getParent(), new FileAttribute[0]);
        System.out.println("Executing " + args);
        Function<IntegrationTestStartedNotifier.Context, IntegrationTestStartedNotifier.Result> startedFunction = LauncherUtil.createStartedFunction();
        this.quarkusProcess = new ProcessBuilder(args).redirectError(logFile.toFile()).redirectOutput(logFile.toFile()).start();
        if (startedFunction != null) {
            IntegrationTestStartedNotifier.Result result = LauncherUtil.waitForStartedFunction(startedFunction, this.quarkusProcess, this.waitTimeSeconds, logFile);
            this.isSsl = result.isSsl();
        } else {
            ListeningAddress result = LauncherUtil.waitForCapturedListeningData(this.quarkusProcess, logFile, this.waitTimeSeconds);
            LauncherUtil.updateConfigForPort(result.getPort());
            this.isSsl = result.isSsl();
        }
    }

    private int getRandomPort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    @Override
    public boolean listensOnSsl() {
        return this.isSsl;
    }

    @Override
    public void includeAsSysProps(Map<String, String> systemProps) {
        this.systemProps.putAll(systemProps);
    }

    private List<String> toEnvVar(String property, String value) {
        if (property != null && !property.isEmpty()) {
            ArrayList<String> result = new ArrayList<String>(2);
            result.add("--env");
            result.add(String.format("%s=%s", this.convertPropertyToEnVar(property), value));
            return result;
        }
        return Collections.emptyList();
    }

    private String convertPropertyToEnVar(String property) {
        return property.toUpperCase().replace('-', '_').replace('.', '_').replace('/', '_');
    }

    @Override
    public void close() {
        this.quarkusProcess.destroy();
    }
}

