/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.security;

import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.QuarkusPrincipal;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.test.junit.callback.QuarkusTestAfterEachCallback;
import io.quarkus.test.junit.callback.QuarkusTestBeforeEachCallback;
import io.quarkus.test.junit.callback.QuarkusTestMethodContext;
import io.quarkus.test.security.TestAuthController;
import io.quarkus.test.security.TestIdentityAssociation;
import io.quarkus.test.security.TestSecurity;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import javax.enterprise.inject.spi.CDI;

public class QuarkusSecurityTestExtension
implements QuarkusTestBeforeEachCallback,
QuarkusTestAfterEachCallback {
    public void afterEach(QuarkusTestMethodContext context) {
        ((TestAuthController)((Object)CDI.current().select(TestAuthController.class, new Annotation[0]).get())).setEnabled(true);
        ((TestIdentityAssociation)((Object)CDI.current().select(TestIdentityAssociation.class, new Annotation[0]).get())).setTestIdentity(null);
    }

    public void beforeEach(QuarkusTestMethodContext context) {
        try {
            Class<?> original;
            ClassLoader cl = QuarkusSecurityTestExtension.class.getClassLoader();
            Method method = original.getDeclaredMethod(context.getTestMethod().getName(), (Class[])Arrays.stream(context.getTestMethod().getParameterTypes()).map(s -> {
                if (s.isPrimitive()) {
                    return s;
                }
                try {
                    return Class.forName(s.getName(), false, cl);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }).toArray(Class[]::new));
            TestSecurity testSecurity = method.getAnnotation(TestSecurity.class);
            if (testSecurity == null) {
                testSecurity = original.getAnnotation(TestSecurity.class);
                for (original = cl.loadClass(context.getTestMethod().getDeclaringClass().getName()); testSecurity == null && original != Object.class; original = original.getSuperclass()) {
                    testSecurity = original.getAnnotation(TestSecurity.class);
                }
            }
            if (testSecurity == null) {
                return;
            }
            ((TestAuthController)((Object)CDI.current().select(TestAuthController.class, new Annotation[0]).get())).setEnabled(testSecurity.authorizationEnabled());
            if (testSecurity.user().isEmpty()) {
                if (testSecurity.roles().length != 0) {
                    throw new RuntimeException("Cannot specify roles without a username in @TestSecurity");
                }
            } else {
                QuarkusSecurityIdentity user = QuarkusSecurityIdentity.builder().setPrincipal((Principal)new QuarkusPrincipal(testSecurity.user())).addRoles(new HashSet<String>(Arrays.asList(testSecurity.roles()))).build();
                ((TestIdentityAssociation)((Object)CDI.current().select(TestIdentityAssociation.class, new Annotation[0]).get())).setTestIdentity((SecurityIdentity)user);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to setup @TestSecurity", e);
        }
    }
}

