/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.deployment;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.deployment.util.HashUtil;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.vertx.deployment.VertxConstants;
import io.quarkus.vertx.runtime.EventConsumerInvoker;
import io.vertx.axle.core.eventbus.Message;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.lang.annotation.Annotation;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

class EventBusConsumer {
    private static final String INVOKER_SUFFIX = "_VertxInvoker";
    private static final MethodDescriptor ARC_CONTAINER = MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]);
    private static final MethodDescriptor INSTANCE_HANDLE_GET = MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]);
    private static final MethodDescriptor ARC_CONTAINER_INSTANCE_FOR_TYPE = MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{Class.class, Annotation[].class});
    private static final MethodDescriptor VERTX_EXECUTE_BLOCKING = MethodDescriptor.ofMethod(Vertx.class, (String)"executeBlocking", Void.TYPE, (Class[])new Class[]{Handler.class, Boolean.TYPE, Handler.class});
    private static final MethodDescriptor FUTURE_COMPLETE = MethodDescriptor.ofMethod(Future.class, (String)"complete", Void.TYPE, (Class[])new Class[]{Object.class});
    private static final MethodDescriptor FUTURE_FAIL = MethodDescriptor.ofMethod(Future.class, (String)"fail", Void.TYPE, (Class[])new Class[]{Throwable.class});
    private static final MethodDescriptor ARC_CONTAINER_BEAN = MethodDescriptor.ofMethod(ArcContainer.class, (String)"bean", InjectableBean.class, (Class[])new Class[]{String.class});
    private static final MethodDescriptor ARC_CONTAINER_INSTANCE_FOR_BEAN = MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{InjectableBean.class});
    private static final MethodDescriptor RX_MESSAGE_NEW_INSTANCE = MethodDescriptor.ofMethod(io.vertx.reactivex.core.eventbus.Message.class, (String)"newInstance", io.vertx.reactivex.core.eventbus.Message.class, (Class[])new Class[]{io.vertx.core.eventbus.Message.class});
    private static final MethodDescriptor AXLE_MESSAGE_NEW_INSTANCE = MethodDescriptor.ofMethod(Message.class, (String)"newInstance", Message.class, (Class[])new Class[]{io.vertx.core.eventbus.Message.class});
    private static final MethodDescriptor MESSAGE_REPLY = MethodDescriptor.ofMethod(io.vertx.core.eventbus.Message.class, (String)"reply", Void.TYPE, (Class[])new Class[]{Object.class});
    private static final MethodDescriptor MESSAGE_BODY = MethodDescriptor.ofMethod(io.vertx.core.eventbus.Message.class, (String)"body", Object.class, (Class[])new Class[0]);
    private static final MethodDescriptor INSTANCE_HANDLE_DESTROY = MethodDescriptor.ofMethod(InstanceHandle.class, (String)"destroy", Void.TYPE, (Class[])new Class[0]);

    static String generateInvoker(BeanInfo bean, MethodInfo method, AnnotationInstance consumeEvent, ClassOutput classOutput) {
        String baseName = bean.getImplClazz().enclosingClass() != null ? DotNames.simpleName((DotName)bean.getImplClazz().enclosingClass()) + "_" + DotNames.simpleName((ClassInfo)bean.getImplClazz()) : DotNames.simpleName((DotName)bean.getImplClazz().name());
        String targetPackage = DotNames.packageName((DotName)bean.getImplClazz().name());
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(method.name()).append("_").append(method.returnType().name().toString());
        for (Type i : method.parameters()) {
            sigBuilder.append(i.name().toString());
        }
        String generatedName = targetPackage.replace('.', '/') + "/" + baseName + INVOKER_SUFFIX + "_" + method.name() + "_" + HashUtil.sha1((String)sigBuilder.toString());
        ClassCreator invokerCreator = ClassCreator.builder().classOutput(classOutput).className(generatedName).interfaces(new Class[]{EventConsumerInvoker.class}).build();
        MethodCreator invoke = invokerCreator.getMethodCreator("invokeBean", Void.TYPE, new Class[]{Object.class});
        ResultHandle containerHandle = invoke.invokeStaticMethod(ARC_CONTAINER, new ResultHandle[0]);
        AnnotationValue blocking = consumeEvent.value("blocking");
        if (blocking != null && blocking.asBoolean()) {
            ResultHandle vertxHandle = invoke.invokeInterfaceMethod(INSTANCE_HANDLE_GET, invoke.invokeInterfaceMethod(ARC_CONTAINER_INSTANCE_FOR_TYPE, containerHandle, new ResultHandle[]{invoke.loadClass(Vertx.class), invoke.newArray(Annotation.class.getName(), invoke.load(0))}), new ResultHandle[0]);
            FunctionCreator func = invoke.createFunction(Handler.class);
            BytecodeCreator funcBytecode = func.getBytecode();
            AssignableResultHandle messageHandle = funcBytecode.createVariable(io.vertx.core.eventbus.Message.class);
            funcBytecode.assign(messageHandle, invoke.getMethodParam(0));
            TryBlock tryBlock = funcBytecode.tryBlock();
            EventBusConsumer.invoke(bean, method, (ResultHandle)messageHandle, (BytecodeCreator)tryBlock);
            tryBlock.invokeInterfaceMethod(FUTURE_COMPLETE, funcBytecode.getMethodParam(0), new ResultHandle[]{tryBlock.loadNull()});
            CatchBlockCreator catchBlock = tryBlock.addCatch(Exception.class);
            catchBlock.invokeInterfaceMethod(FUTURE_FAIL, funcBytecode.getMethodParam(0), new ResultHandle[]{catchBlock.getMethodParam(0)});
            funcBytecode.returnValue(null);
            invoke.invokeInterfaceMethod(VERTX_EXECUTE_BLOCKING, vertxHandle, new ResultHandle[]{func.getInstance(), invoke.load(false), invoke.loadNull()});
        } else {
            EventBusConsumer.invoke(bean, method, invoke.getMethodParam(0), (BytecodeCreator)invoke);
        }
        invoke.returnValue(null);
        invokerCreator.close();
        return generatedName.replace('/', '.');
    }

    private static void invoke(BeanInfo bean, MethodInfo method, ResultHandle messageHandle, BytecodeCreator invoke) {
        ResultHandle containerHandle = invoke.invokeStaticMethod(ARC_CONTAINER, new ResultHandle[0]);
        ResultHandle beanHandle = invoke.invokeInterfaceMethod(ARC_CONTAINER_BEAN, containerHandle, new ResultHandle[]{invoke.load(bean.getIdentifier())});
        ResultHandle instanceHandle = invoke.invokeInterfaceMethod(ARC_CONTAINER_INSTANCE_FOR_BEAN, containerHandle, new ResultHandle[]{beanHandle});
        ResultHandle beanInstanceHandle = invoke.invokeInterfaceMethod(INSTANCE_HANDLE_GET, instanceHandle, new ResultHandle[0]);
        Type paramType = (Type)method.parameters().get(0);
        if (paramType.name().equals((Object)VertxConstants.MESSAGE)) {
            invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)bean.getImplClazz().name().toString(), (String)method.name(), Void.TYPE, (Object[])new Object[]{io.vertx.core.eventbus.Message.class}), beanInstanceHandle, new ResultHandle[]{messageHandle});
        } else if (paramType.name().equals((Object)VertxConstants.RX_MESSAGE)) {
            ResultHandle rxMessageHandle = invoke.invokeStaticMethod(RX_MESSAGE_NEW_INSTANCE, new ResultHandle[]{messageHandle});
            invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)bean.getImplClazz().name().toString(), (String)method.name(), Void.TYPE, (Object[])new Object[]{io.vertx.reactivex.core.eventbus.Message.class}), beanInstanceHandle, new ResultHandle[]{rxMessageHandle});
        } else if (paramType.name().equals((Object)VertxConstants.AXLE_MESSAGE)) {
            ResultHandle axleMessageHandle = invoke.invokeStaticMethod(AXLE_MESSAGE_NEW_INSTANCE, new ResultHandle[]{messageHandle});
            invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)bean.getImplClazz().name().toString(), (String)method.name(), Void.TYPE, (Object[])new Object[]{Message.class}), beanInstanceHandle, new ResultHandle[]{axleMessageHandle});
        } else {
            ResultHandle bodyHandle = invoke.invokeInterfaceMethod(MESSAGE_BODY, messageHandle, new ResultHandle[0]);
            ResultHandle replyHandle = invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((String)bean.getImplClazz().name().toString(), (String)method.name(), (String)method.returnType().name().toString(), (String[])new String[]{paramType.name().toString()}), beanInstanceHandle, new ResultHandle[]{bodyHandle});
            if (replyHandle != null) {
                if (method.returnType().name().equals((Object)VertxConstants.COMPLETION_STAGE)) {
                    FunctionCreator func = invoke.createFunction(Consumer.class);
                    BytecodeCreator funcBytecode = func.getBytecode();
                    funcBytecode.invokeInterfaceMethod(MESSAGE_REPLY, messageHandle, new ResultHandle[]{funcBytecode.getMethodParam(0)});
                    funcBytecode.returnValue(null);
                    invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(CompletionStage.class, (String)"thenAccept", CompletionStage.class, (Class[])new Class[]{Consumer.class}), replyHandle, new ResultHandle[]{func.getInstance()});
                } else {
                    invoke.invokeInterfaceMethod(MESSAGE_REPLY, messageHandle, new ResultHandle[]{replyHandle});
                }
            }
        }
        if (BuiltinScope.DEPENDENT.is(bean.getScope())) {
            invoke.invokeInterfaceMethod(INSTANCE_HANDLE_DESTROY, instanceHandle, new ResultHandle[0]);
        }
    }

    private EventBusConsumer() {
    }
}

