/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AnnotationProxyBuildItem;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.vertx.ConsumeEvent;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import io.quarkus.vertx.deployment.EventBusConsumer;
import io.quarkus.vertx.deployment.EventConsumerBusinessMethodItem;
import io.quarkus.vertx.deployment.MessageCodecBuildItem;
import io.quarkus.vertx.deployment.VertxBuildItem;
import io.quarkus.vertx.deployment.VertxConstants;
import io.quarkus.vertx.runtime.VertxProducer;
import io.quarkus.vertx.runtime.VertxRecorder;
import io.vertx.core.Vertx;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

class VertxProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)VertxProcessor.class.getName());
    @Inject
    BuildProducer<ReflectiveClassBuildItem> reflectiveClass;

    VertxProcessor() {
    }

    @BuildStep
    void featureAndCapability(BuildProducer<FeatureBuildItem> feature, BuildProducer<CapabilityBuildItem> capability) {
        feature.produce((BuildItem)new FeatureBuildItem("vertx"));
        capability.produce((BuildItem)new CapabilityBuildItem("io.quarkus.resteasy-json"));
    }

    @BuildStep
    AdditionalBeanBuildItem registerBean() {
        return AdditionalBeanBuildItem.unremovableOf(VertxProducer.class);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    VertxBuildItem build(CoreVertxBuildItem internalVertx, VertxRecorder recorder, BeanContainerBuildItem beanContainer, List<EventConsumerBusinessMethodItem> messageConsumerBusinessMethods, BuildProducer<GeneratedClassBuildItem> generatedClass, AnnotationProxyBuildItem annotationProxy, LaunchModeBuildItem launchMode, ShutdownContextBuildItem shutdown, BuildProducer<ServiceStartBuildItem> serviceStart, List<MessageCodecBuildItem> codecs, RecorderContext recorderContext) {
        HashMap<String, Object> messageConsumerConfigurations = new HashMap<String, Object>();
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClass, true);
        for (EventConsumerBusinessMethodItem businessMethod : messageConsumerBusinessMethods) {
            String invokerClass = EventBusConsumer.generateInvoker(businessMethod.getBean(), businessMethod.getMethod(), businessMethod.getConsumeEvent(), (ClassOutput)classOutput);
            messageConsumerConfigurations.put(invokerClass, annotationProxy.builder(businessMethod.getConsumeEvent(), ConsumeEvent.class).withDefaultValue("value", (Object)businessMethod.getBean().getBeanClass().toString()).build((ClassOutput)classOutput));
            this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{invokerClass}));
        }
        HashMap<Class, Class> codecByClass = new HashMap<Class, Class>();
        for (MessageCodecBuildItem messageCodecItem : codecs) {
            codecByClass.put(recorderContext.classProxy(messageCodecItem.getType()), recorderContext.classProxy(messageCodecItem.getCodec()));
        }
        recorder.configureVertx(internalVertx.getVertx(), messageConsumerConfigurations, launchMode.getLaunchMode(), (ShutdownContext)shutdown, codecByClass);
        serviceStart.produce((BuildItem)new ServiceStartBuildItem("vertx"));
        return new VertxBuildItem((RuntimeValue<Vertx>)recorder.forceStart(internalVertx.getVertx()));
    }

    @BuildStep
    public UnremovableBeanBuildItem unremovableBeans() {
        return new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(VertxConstants.CONSUME_EVENT));
    }

    @BuildStep
    void validateBeanDeployment(ValidationPhaseBuildItem validationPhase, BuildProducer<EventConsumerBusinessMethodItem> messageConsumerBusinessMethods, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        AnnotationStore annotationStore = (AnnotationStore)validationPhase.getContext().get(BuildExtension.Key.ANNOTATION_STORE);
        for (BeanInfo bean : validationPhase.getContext().beans().classBeans()) {
            for (MethodInfo method : ((AnnotationTarget)bean.getTarget().get()).asClass().methods()) {
                AnnotationInstance consumeEvent = annotationStore.getAnnotation((AnnotationTarget)method, VertxConstants.CONSUME_EVENT);
                if (consumeEvent == null) continue;
                List params = method.parameters();
                if (params.size() != 1) {
                    throw new IllegalStateException(String.format("Event consumer business method must accept exactly one parameter: %s [method: %s, bean:%s", params, method, bean));
                }
                messageConsumerBusinessMethods.produce((BuildItem)new EventConsumerBusinessMethodItem(bean, method, consumeEvent));
                LOGGER.debugf("Found event consumer business method %s declared on %s", (Object)method, (Object)bean);
            }
        }
    }

    @BuildStep
    AnnotationsTransformerBuildItem annotationTransformer() {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                if (!BuiltinScope.isIn((Iterable)context.getAnnotations()) && context.getTarget().asClass().annotations().containsKey(VertxConstants.CONSUME_EVENT)) {
                    LOGGER.debugf("Found event consumer business methods on a class %s with no scope annotation - adding @Singleton", (Object)context.getTarget());
                    ((Transformation)context.transform().add(Singleton.class, new AnnotationValue[0])).done();
                }
            }
        });
    }
}

