/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.arc.Arc;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.bootstrap.runner.Timing;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.netty.runtime.virtual.VirtualAddress;
import io.quarkus.netty.runtime.virtual.VirtualChannel;
import io.quarkus.netty.runtime.virtual.VirtualServerChannel;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.LiveReloadConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.ConfigInstantiator;
import io.quarkus.runtime.configuration.MemorySize;
import io.quarkus.runtime.shutdown.ShutdownConfig;
import io.quarkus.vertx.core.runtime.VertxCoreRecorder;
import io.quarkus.vertx.core.runtime.config.VertxConfiguration;
import io.quarkus.vertx.http.runtime.AccessLogConfig;
import io.quarkus.vertx.http.runtime.BodyConfig;
import io.quarkus.vertx.http.runtime.ForwardedServerRequestWrapper;
import io.quarkus.vertx.http.runtime.ForwardingProxyOptions;
import io.quarkus.vertx.http.runtime.HandlerType;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.QuarkusErrorHandler;
import io.quarkus.vertx.http.runtime.ResumingRequestWrapper;
import io.quarkus.vertx.http.runtime.RouterProducer;
import io.quarkus.vertx.http.runtime.SameSiteCookieConfig;
import io.quarkus.vertx.http.runtime.SameSiteNoneIncompatibleClientChecker;
import io.quarkus.vertx.http.runtime.ServerSslConfig;
import io.quarkus.vertx.http.runtime.devmode.RemoteSyncHandler;
import io.quarkus.vertx.http.runtime.filters.Filter;
import io.quarkus.vertx.http.runtime.filters.Filters;
import io.quarkus.vertx.http.runtime.filters.GracefulShutdownFilter;
import io.quarkus.vertx.http.runtime.filters.QuarkusRequestWrapper;
import io.quarkus.vertx.http.runtime.filters.accesslog.AccessLogHandler;
import io.quarkus.vertx.http.runtime.filters.accesslog.AccessLogReceiver;
import io.quarkus.vertx.http.runtime.filters.accesslog.DefaultAccessLogReceiver;
import io.quarkus.vertx.http.runtime.filters.accesslog.JBossLoggingAccessLogReceiver;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.CookieSameSite;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.enterprise.event.Event;
import org.jboss.logging.Logger;
import org.wildfly.common.cpu.ProcessorInfo;

@Recorder
public class VertxHttpRecorder {
    public static final String REQUEST_START_TIME = "io.quarkus.request-start-time";
    public static final String MAX_REQUEST_SIZE_KEY = "io.quarkus.max-request-size";
    public static final int DEFAULT_ROUTE_ORDER = 10000;
    private static final Logger LOGGER = Logger.getLogger((String)VertxHttpRecorder.class.getName());
    private static volatile Handler<RoutingContext> hotReplacementHandler;
    private static volatile HotReplacementContext hotReplacementContext;
    private static volatile RemoteSyncHandler remoteSyncHandler;
    private static volatile Runnable closeTask;
    private static volatile Handler<HttpServerRequest> rootHandler;
    private static volatile Handler<RoutingContext> nonApplicationRedirectHandler;
    private static volatile int actualHttpPort;
    private static volatile int actualHttpsPort;
    public static final String GET = "GET";
    private static final Handler<HttpServerRequest> ACTUAL_ROOT;
    protected static ServerBootstrap virtualBootstrap;
    public static VirtualAddress VIRTUAL_HTTP;
    private static final List<HttpMethod> CAN_HAVE_BODY;

    public static void setHotReplacement(Handler<RoutingContext> handler, HotReplacementContext hrc) {
        hotReplacementHandler = handler;
        hotReplacementContext = hrc;
    }

    public static void shutDownDevMode() {
        if (closeTask != null) {
            closeTask.run();
            closeTask = null;
        }
        rootHandler = null;
        hotReplacementHandler = null;
    }

    public static void startServerAfterFailedStart() {
        Vertx vertx;
        Supplier supplier;
        if (closeTask != null) {
            Handler<RoutingContext> prevHotReplacementHandler = hotReplacementHandler;
            VertxHttpRecorder.shutDownDevMode();
            hotReplacementHandler = prevHotReplacementHandler;
        }
        if ((supplier = VertxCoreRecorder.getVertx()) == null) {
            VertxConfiguration vertxConfiguration = new VertxConfiguration();
            ConfigInstantiator.handleObject((Object)vertxConfiguration);
            vertx = (Vertx)VertxCoreRecorder.recoverFailedStart((VertxConfiguration)vertxConfiguration).get();
        } else {
            vertx = (Vertx)supplier.get();
        }
        try {
            HttpBuildTimeConfig buildConfig = new HttpBuildTimeConfig();
            ConfigInstantiator.handleObject((Object)buildConfig);
            HttpConfiguration config = new HttpConfiguration();
            ConfigInstantiator.handleObject((Object)config);
            if (config.host == null) {
                config.host = "localhost";
            }
            Router router = Router.router((Vertx)vertx);
            if (hotReplacementHandler != null) {
                router.route().order(Integer.MIN_VALUE).blockingHandler(hotReplacementHandler);
            }
            Object root = router;
            LiveReloadConfig liveReloadConfig = new LiveReloadConfig();
            ConfigInstantiator.handleObject((Object)liveReloadConfig);
            if (liveReloadConfig.password.isPresent() && hotReplacementContext.getDevModeType() == DevModeType.REMOTE_SERVER_SIDE) {
                remoteSyncHandler = new RemoteSyncHandler((String)liveReloadConfig.password.get(), (Handler<HttpServerRequest>)root, hotReplacementContext);
                root = remoteSyncHandler;
            }
            rootHandler = root;
            VertxHttpRecorder.doServerStart(vertx, buildConfig, config, LaunchMode.DEVELOPMENT, new Supplier<Integer>(){

                @Override
                public Integer get() {
                    return ProcessorInfo.availableProcessors() * 2;
                }
            }, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RuntimeValue<Router> initializeRouter(Supplier<Vertx> vertxRuntimeValue) {
        Vertx vertx = vertxRuntimeValue.get();
        Router router = Router.router((Vertx)vertx);
        return new RuntimeValue((Object)router);
    }

    public void startServer(Supplier<Vertx> vertx, ShutdownContext shutdown, HttpBuildTimeConfig httpBuildTimeConfig, HttpConfiguration httpConfiguration, LaunchMode launchMode, boolean startVirtual, boolean startSocket, Supplier<Integer> ioThreads, String websocketSubProtocols) throws IOException {
        if (startVirtual) {
            VertxHttpRecorder.initializeVirtual(vertx.get());
        }
        if (startSocket && closeTask == null) {
            VertxHttpRecorder.doServerStart(vertx.get(), httpBuildTimeConfig, httpConfiguration, launchMode, ioThreads, websocketSubProtocols);
            if (launchMode != LaunchMode.DEVELOPMENT) {
                shutdown.addShutdownTask(closeTask);
            }
        }
    }

    public void mountFrameworkRouter(RuntimeValue<Router> mainRouter, RuntimeValue<Router> frameworkRouter, String frameworkPath) {
        ((Router)mainRouter.getValue()).mountSubRouter(frameworkPath, (Router)frameworkRouter.getValue());
    }

    public void finalizeRouter(BeanContainer container, Consumer<Route> defaultRouteHandler, List<Filter> filterList, Supplier<Vertx> vertx, LiveReloadConfig liveReloadConfig, RuntimeValue<Router> runtimeValue, String rootPath, LaunchMode launchMode, boolean requireBodyHandler, final Handler<RoutingContext> bodyHandler, HttpConfiguration httpConfiguration, GracefulShutdownFilter gracefulShutdownFilter, ShutdownConfig shutdownConfig, Executor executor) {
        Object root;
        Router router = (Router)runtimeValue.getValue();
        Event event = Arc.container().beanManager().getEvent();
        Filters filters = new Filters();
        event.select(Filters.class, new Annotation[0]).fire((Object)filters);
        filterList.addAll(filters.getFilters());
        event.select(Router.class, new Annotation[0]).fire((Object)router);
        for (Filter filter : filterList) {
            if (filter.getHandler() == null) continue;
            router.route().order(-1 * filter.getPriority()).handler(filter.getHandler());
        }
        if (defaultRouteHandler != null) {
            defaultRouteHandler.accept(router.route().order(10000));
        }
        ((RouterProducer)container.instance(RouterProducer.class, new Annotation[0])).initialize(router);
        router.route().last().failureHandler((Handler)new QuarkusErrorHandler(launchMode.isDevOrTest()));
        if (requireBodyHandler) {
            router.route().order(-2147483647).handler((Handler)new Handler<RoutingContext>(){

                public void handle(RoutingContext routingContext) {
                    routingContext.request().resume();
                    bodyHandler.handle((Object)routingContext);
                }
            });
        }
        if (httpConfiguration.limits.maxBodySize.isPresent()) {
            final long limit = httpConfiguration.limits.maxBodySize.get().asLongValue();
            final Long limitObj = limit;
            router.route().order(-2).handler((Handler)new Handler<RoutingContext>(){

                public void handle(final RoutingContext event) {
                    String lengthString = event.request().headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                    if (lengthString != null) {
                        long length = Long.parseLong(lengthString);
                        if (length > limit) {
                            event.response().headers().add((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)"close");
                            event.response().setStatusCode(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE.code());
                            event.response().endHandler((Handler)new Handler<Void>(){

                                public void handle(Void e) {
                                    event.request().connection().close();
                                }
                            });
                            event.response().end();
                            return;
                        }
                    } else {
                        event.put(VertxHttpRecorder.MAX_REQUEST_SIZE_KEY, (Object)limitObj);
                    }
                    event.next();
                }
            });
        }
        if (rootPath.equals("/")) {
            if (hotReplacementHandler != null) {
                final ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
                router.route().order(Integer.MIN_VALUE).handler((Handler)new Handler<RoutingContext>(){

                    public void handle(RoutingContext event) {
                        Thread.currentThread().setContextClassLoader(currentCl);
                        hotReplacementHandler.handle((Object)event);
                    }
                });
            }
            root = router;
        } else {
            Router mainRouter = Router.router((Vertx)vertx.get());
            mainRouter.mountSubRouter(rootPath, router);
            if (hotReplacementHandler != null) {
                final ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
                mainRouter.route().order(Integer.MIN_VALUE).handler((Handler)new Handler<RoutingContext>(){

                    public void handle(RoutingContext event) {
                        Thread.currentThread().setContextClassLoader(currentCl);
                        hotReplacementHandler.handle((Object)event);
                    }
                });
            }
            root = mainRouter;
        }
        this.warnIfDeprecatedHttpConfigPropertiesPresent(httpConfiguration);
        ForwardingProxyOptions forwardingProxyOptions = ForwardingProxyOptions.from(httpConfiguration);
        if (forwardingProxyOptions.proxyAddressForwarding) {
            Router delegate = root;
            root = new Handler<HttpServerRequest>((Handler)delegate, forwardingProxyOptions){
                final /* synthetic */ Handler val$delegate;
                final /* synthetic */ ForwardingProxyOptions val$forwardingProxyOptions;
                {
                    this.val$delegate = handler;
                    this.val$forwardingProxyOptions = forwardingProxyOptions;
                }

                public void handle(HttpServerRequest event) {
                    this.val$delegate.handle((Object)new ForwardedServerRequestWrapper(event, this.val$forwardingProxyOptions));
                }
            };
        }
        boolean quarkusWrapperNeeded = false;
        if (shutdownConfig.isShutdownTimeoutSet()) {
            gracefulShutdownFilter.next((Handler<HttpServerRequest>)root);
            root = gracefulShutdownFilter;
            quarkusWrapperNeeded = true;
        }
        AccessLogConfig accessLog = httpConfiguration.accessLog;
        if (accessLog.enabled) {
            AccessLogReceiver receiver;
            if (accessLog.logToFile) {
                File outputDir = accessLog.logDirectory.isPresent() ? new File(accessLog.logDirectory.get()) : new File("");
                receiver = new DefaultAccessLogReceiver(executor, outputDir, accessLog.baseFileName, accessLog.logSuffix, accessLog.rotate);
            } else {
                receiver = new JBossLoggingAccessLogReceiver(accessLog.category);
            }
            AccessLogHandler handler = new AccessLogHandler(receiver, accessLog.pattern, this.getClass().getClassLoader());
            router.route().order(Integer.MIN_VALUE).handler((Handler)handler);
            quarkusWrapperNeeded = true;
        }
        BiConsumer<Cookie, HttpServerRequest> cookieFunction = null;
        if (!httpConfiguration.sameSiteCookie.isEmpty()) {
            cookieFunction = this.processSameSiteConfig(httpConfiguration.sameSiteCookie);
            quarkusWrapperNeeded = true;
        }
        BiConsumer<Cookie, HttpServerRequest> cookieConsumer = cookieFunction;
        if (quarkusWrapperNeeded) {
            Object old = root;
            root = new Handler<HttpServerRequest>((Handler)old, cookieConsumer){
                final /* synthetic */ Handler val$old;
                final /* synthetic */ BiConsumer val$cookieConsumer;
                {
                    this.val$old = handler;
                    this.val$cookieConsumer = biConsumer;
                }

                public void handle(HttpServerRequest event) {
                    this.val$old.handle((Object)new QuarkusRequestWrapper(event, this.val$cookieConsumer));
                }
            };
        }
        Object delegate = root;
        root = new Handler<HttpServerRequest>((Handler)delegate){
            final /* synthetic */ Handler val$delegate;
            {
                this.val$delegate = handler;
            }

            public void handle(HttpServerRequest event) {
                this.val$delegate.handle((Object)new ResumingRequestWrapper(event));
            }
        };
        if (httpConfiguration.recordRequestStartTime) {
            router.route().order(Integer.MIN_VALUE).handler((Handler)new Handler<RoutingContext>(){

                public void handle(RoutingContext event) {
                    event.put(VertxHttpRecorder.REQUEST_START_TIME, (Object)System.nanoTime());
                    event.next();
                }
            });
        }
        if (launchMode == LaunchMode.DEVELOPMENT && liveReloadConfig.password.isPresent() && hotReplacementContext.getDevModeType() == DevModeType.REMOTE_SERVER_SIDE) {
            remoteSyncHandler = new RemoteSyncHandler((String)liveReloadConfig.password.get(), (Handler<HttpServerRequest>)root, hotReplacementContext);
            root = remoteSyncHandler;
        }
        rootHandler = root;
    }

    private void warnIfDeprecatedHttpConfigPropertiesPresent(HttpConfiguration httpConfiguration) {
        if (httpConfiguration.proxyAddressForwarding.isPresent()) {
            LOGGER.warn((Object)"`quarkus.http.proxy-address-forwarding` is deprecated and will be removed in a future version - it is recommended to switch to `quarkus.http.proxy.proxy-address-forwarding`");
        }
        if (httpConfiguration.allowForwarded.isPresent()) {
            LOGGER.warn((Object)"`quarkus.http.allow-forwarded` is deprecated and will be removed in a future version - it is recommended to switch to `quarkus.http.proxy.allow-forwarded`");
        }
    }

    private static void doServerStart(final Vertx vertx, HttpBuildTimeConfig httpBuildTimeConfig, final HttpConfiguration httpConfiguration, final LaunchMode launchMode, Supplier<Integer> eventLoops, String websocketSubProtocols) throws IOException {
        final HttpServerOptions httpServerOptions = VertxHttpRecorder.createHttpServerOptions(httpConfiguration, launchMode, websocketSubProtocols);
        final HttpServerOptions domainSocketOptions = VertxHttpRecorder.createDomainSocketOptions(httpConfiguration, websocketSubProtocols);
        final HttpServerOptions sslConfig = VertxHttpRecorder.createSslOptions(httpBuildTimeConfig, httpConfiguration, launchMode);
        if (httpConfiguration.insecureRequests != HttpConfiguration.InsecureRequests.ENABLED && sslConfig == null) {
            throw new IllegalStateException("Cannot set quarkus.http.redirect-insecure-requests without enabling SSL.");
        }
        int eventLoopCount = eventLoops.get();
        int ioThreads = httpConfiguration.ioThreads.isPresent() ? Math.min(httpConfiguration.ioThreads.getAsInt(), eventLoopCount) : eventLoopCount;
        final CompletableFuture futureResult = new CompletableFuture();
        vertx.deployVerticle((Supplier)new Supplier<Verticle>(){

            @Override
            public Verticle get() {
                return new WebDeploymentVerticle(httpServerOptions, sslConfig, domainSocketOptions, launchMode, httpConfiguration.insecureRequests);
            }
        }, new DeploymentOptions().setInstances(ioThreads), (Handler)new Handler<AsyncResult<String>>(){

            public void handle(AsyncResult<String> event) {
                if (event.failed()) {
                    futureResult.completeExceptionally(event.cause());
                } else {
                    futureResult.complete(event.result());
                }
            }
        });
        try {
            final String deploymentId = (String)futureResult.get();
            VertxCoreRecorder.setWebDeploymentId((String)deploymentId);
            closeTask = new Runnable(){

                @Override
                public synchronized void run() {
                    if (closeTask == this) {
                        if (vertx.deploymentIDs().contains(deploymentId)) {
                            final CountDownLatch latch = new CountDownLatch(1);
                            try {
                                vertx.undeploy(deploymentId, (Handler)new Handler<AsyncResult<Void>>(){

                                    public void handle(AsyncResult<Void> event) {
                                        latch.countDown();
                                    }
                                });
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            try {
                                latch.await();
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        closeTask = null;
                        if (remoteSyncHandler != null) {
                            remoteSyncHandler.close();
                            remoteSyncHandler = null;
                        }
                    }
                }
            };
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Unable to start HTTP server", e);
        }
        VertxHttpRecorder.setHttpServerTiming(httpConfiguration.insecureRequests, httpServerOptions, sslConfig, domainSocketOptions);
    }

    private static void setHttpServerTiming(HttpConfiguration.InsecureRequests insecureRequests, HttpServerOptions httpServerOptions, HttpServerOptions sslConfig, HttpServerOptions domainSocketOptions) {
        String serverListeningMessage = "Listening on: ";
        int socketCount = 0;
        if (httpServerOptions != null && !HttpConfiguration.InsecureRequests.DISABLED.equals((Object)insecureRequests)) {
            serverListeningMessage = serverListeningMessage + String.format("http://%s:%s", httpServerOptions.getHost(), actualHttpPort);
            ++socketCount;
        }
        if (sslConfig != null) {
            if (socketCount > 0) {
                serverListeningMessage = serverListeningMessage + " and ";
            }
            serverListeningMessage = serverListeningMessage + String.format("https://%s:%s", sslConfig.getHost(), actualHttpsPort);
            ++socketCount;
        }
        if (domainSocketOptions != null) {
            if (socketCount > 0) {
                serverListeningMessage = serverListeningMessage + " and ";
            }
            serverListeningMessage = serverListeningMessage + String.format("unix:%s", domainSocketOptions.getHost());
        }
        Timing.setHttpServer((String)serverListeningMessage);
    }

    private static HttpServerOptions createSslOptions(HttpBuildTimeConfig buildTimeConfig, HttpConfiguration httpConfiguration, LaunchMode launchMode) throws IOException {
        if (!httpConfiguration.hostEnabled) {
            return null;
        }
        ServerSslConfig sslConfig = httpConfiguration.ssl;
        Optional<Path> certFile = sslConfig.certificate.file;
        Optional<Path> keyFile = sslConfig.certificate.keyFile;
        Optional<Path> keyStoreFile = sslConfig.certificate.keyStoreFile;
        String keystorePassword = sslConfig.certificate.keyStorePassword;
        Optional<Path> trustStoreFile = sslConfig.certificate.trustStoreFile;
        Optional<String> trustStorePassword = sslConfig.certificate.trustStorePassword;
        HttpServerOptions serverOptions = new HttpServerOptions();
        if (JdkSSLEngineOptions.isAlpnAvailable()) {
            serverOptions.setUseAlpn(httpConfiguration.http2);
            if (httpConfiguration.http2) {
                serverOptions.setAlpnVersions(Arrays.asList(HttpVersion.HTTP_2, HttpVersion.HTTP_1_1));
            }
        }
        serverOptions.setMaxHeaderSize(httpConfiguration.limits.maxHeaderSize.asBigInteger().intValueExact());
        serverOptions.setMaxChunkSize(httpConfiguration.limits.maxChunkSize.asBigInteger().intValueExact());
        VertxHttpRecorder.setIdleTimeout(httpConfiguration, serverOptions);
        if (certFile.isPresent() && keyFile.isPresent()) {
            VertxHttpRecorder.createPemKeyCertOptions(certFile.get(), keyFile.get(), serverOptions);
        } else if (keyStoreFile.isPresent()) {
            Path keyStorePath = keyStoreFile.get();
            Optional<String> keyStoreFileType = sslConfig.certificate.keyStoreFileType;
            String type = keyStoreFileType.isPresent() ? keyStoreFileType.get().toLowerCase() : VertxHttpRecorder.findKeystoreFileType(keyStorePath);
            byte[] data = VertxHttpRecorder.getFileContent(keyStorePath);
            switch (type) {
                case "pkcs12": {
                    PfxOptions options = new PfxOptions().setPassword(keystorePassword).setValue(Buffer.buffer((byte[])data));
                    serverOptions.setPfxKeyCertOptions(options);
                    break;
                }
                case "jks": {
                    PfxOptions options = new JksOptions().setPassword(keystorePassword).setValue(Buffer.buffer((byte[])data));
                    serverOptions.setKeyStoreOptions((JksOptions)options);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown keystore type: " + type + " valid types are jks or pkcs12");
                }
            }
        } else {
            return null;
        }
        if (trustStoreFile.isPresent()) {
            if (!trustStorePassword.isPresent()) {
                throw new IllegalArgumentException("No trust store password provided");
            }
            Optional<String> trustStoreFileType = sslConfig.certificate.trustStoreFileType;
            Path trustStoreFilePath = trustStoreFile.get();
            String type = trustStoreFileType.isPresent() ? trustStoreFileType.get().toLowerCase() : VertxHttpRecorder.findKeystoreFileType(trustStoreFilePath);
            VertxHttpRecorder.createTrustStoreOptions(trustStoreFilePath, trustStorePassword.get(), type, serverOptions);
        }
        for (String cipher : sslConfig.cipherSuites.orElse(Collections.emptyList())) {
            serverOptions.addEnabledCipherSuite(cipher);
        }
        for (String protocol : sslConfig.protocols) {
            if (protocol.isEmpty()) continue;
            serverOptions.addEnabledSecureTransportProtocol(protocol);
        }
        serverOptions.setSsl(true);
        serverOptions.setHost(httpConfiguration.host);
        serverOptions.setPort(httpConfiguration.determineSslPort(launchMode));
        serverOptions.setClientAuth(buildTimeConfig.tlsClientAuth);
        serverOptions.setReusePort(httpConfiguration.soReusePort);
        serverOptions.setTcpQuickAck(httpConfiguration.tcpQuickAck);
        serverOptions.setTcpCork(httpConfiguration.tcpCork);
        serverOptions.setTcpFastOpen(httpConfiguration.tcpFastOpen);
        serverOptions.setMaxInitialLineLength(httpConfiguration.limits.maxInitialLineLength);
        return serverOptions;
    }

    private static byte[] getFileContent(Path path) throws IOException {
        byte[] data;
        InputStream resource = Thread.currentThread().getContextClassLoader().getResourceAsStream(path.toString());
        if (resource != null) {
            try (InputStream is = resource;){
                data = VertxHttpRecorder.doRead(is);
            }
        }
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            data = VertxHttpRecorder.doRead(is);
        }
        return data;
    }

    private static void createPemKeyCertOptions(Path certFile, Path keyFile, HttpServerOptions serverOptions) throws IOException {
        byte[] cert = VertxHttpRecorder.getFileContent(certFile);
        byte[] key = VertxHttpRecorder.getFileContent(keyFile);
        PemKeyCertOptions pemKeyCertOptions = new PemKeyCertOptions().setCertValue(Buffer.buffer((byte[])cert)).setKeyValue(Buffer.buffer((byte[])key));
        serverOptions.setPemKeyCertOptions(pemKeyCertOptions);
    }

    private static void createTrustStoreOptions(Path trustStoreFile, String trustStorePassword, String trustStoreFileType, HttpServerOptions serverOptions) throws IOException {
        byte[] data = VertxHttpRecorder.getFileContent(trustStoreFile);
        switch (trustStoreFileType) {
            case "pkcs12": {
                PfxOptions options = new PfxOptions().setPassword(trustStorePassword).setValue(Buffer.buffer((byte[])data));
                serverOptions.setPfxTrustOptions(options);
                break;
            }
            case "jks": {
                JksOptions options = new JksOptions().setPassword(trustStorePassword).setValue(Buffer.buffer((byte[])data));
                serverOptions.setTrustStoreOptions(options);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown truststore type: " + trustStoreFileType + " valid types are jks or pkcs12");
            }
        }
    }

    private static String findKeystoreFileType(Path storePath) {
        String pathName = storePath.toString();
        if (pathName.endsWith(".p12") || pathName.endsWith(".pkcs12") || pathName.endsWith(".pfx")) {
            return "pkcs12";
        }
        return "jks";
    }

    private static byte[] doRead(InputStream is) throws IOException {
        int r;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((r = is.read(buf)) > 0) {
            out.write(buf, 0, r);
        }
        return out.toByteArray();
    }

    private static HttpServerOptions createHttpServerOptions(HttpConfiguration httpConfiguration, LaunchMode launchMode, String websocketSubProtocols) {
        if (!httpConfiguration.hostEnabled) {
            return null;
        }
        HttpServerOptions options = new HttpServerOptions();
        options.setHost(httpConfiguration.host);
        options.setPort(httpConfiguration.determinePort(launchMode));
        VertxHttpRecorder.setIdleTimeout(httpConfiguration, options);
        options.setMaxHeaderSize(httpConfiguration.limits.maxHeaderSize.asBigInteger().intValueExact());
        options.setMaxChunkSize(httpConfiguration.limits.maxChunkSize.asBigInteger().intValueExact());
        options.setWebsocketSubProtocols(websocketSubProtocols);
        options.setReusePort(httpConfiguration.soReusePort);
        options.setTcpQuickAck(httpConfiguration.tcpQuickAck);
        options.setTcpCork(httpConfiguration.tcpCork);
        options.setTcpFastOpen(httpConfiguration.tcpFastOpen);
        options.setCompressionSupported(httpConfiguration.enableCompression);
        options.setMaxInitialLineLength(httpConfiguration.limits.maxInitialLineLength);
        return options;
    }

    private static HttpServerOptions createDomainSocketOptions(HttpConfiguration httpConfiguration, String websocketSubProtocols) {
        if (!httpConfiguration.domainSocketEnabled) {
            return null;
        }
        HttpServerOptions options = new HttpServerOptions();
        options.setHost(httpConfiguration.domainSocket);
        VertxHttpRecorder.setIdleTimeout(httpConfiguration, options);
        options.setMaxHeaderSize(httpConfiguration.limits.maxHeaderSize.asBigInteger().intValueExact());
        options.setMaxChunkSize(httpConfiguration.limits.maxChunkSize.asBigInteger().intValueExact());
        options.setWebsocketSubProtocols(websocketSubProtocols);
        return options;
    }

    private static void setIdleTimeout(HttpConfiguration httpConfiguration, HttpServerOptions options) {
        int idleTimeout = (int)httpConfiguration.idleTimeout.toMillis();
        options.setIdleTimeout(idleTimeout);
        options.setIdleTimeoutUnit(TimeUnit.MILLISECONDS);
    }

    public void warnIfPortChanged(HttpConfiguration config, int port) {
        if (config.port != port) {
            LOGGER.errorf("quarkus.http.port was specified at build time as %s however run time value is %s, Kubernetes metadata will be incorrect.", (Object)port, (Object)config.port);
        }
    }

    public void addRoute(RuntimeValue<Router> router, Function<Router, Route> route, Handler<RoutingContext> handler, HandlerType blocking) {
        Route vr = route.apply((Router)router.getValue());
        Handler<RoutingContext> requestHandler = handler;
        if (blocking == HandlerType.BLOCKING) {
            vr.blockingHandler(requestHandler, false);
        } else if (blocking == HandlerType.FAILURE) {
            vr.failureHandler(requestHandler);
        } else {
            vr.handler(requestHandler);
        }
    }

    public void setNonApplicationRedirectHandler(final String nonApplicationPath) {
        nonApplicationRedirectHandler = new Handler<RoutingContext>(){

            public void handle(RoutingContext context) {
                String absoluteURI = context.request().absoluteURI();
                int pathStart = absoluteURI.indexOf(context.request().path());
                String redirectTo = absoluteURI.substring(0, pathStart) + nonApplicationPath + absoluteURI.substring(pathStart);
                context.response().setStatusCode(HttpResponseStatus.MOVED_PERMANENTLY.code()).putHeader((CharSequence)HttpHeaderNames.LOCATION, (CharSequence)redirectTo).end();
            }
        };
    }

    public Handler<RoutingContext> getNonApplicationRedirectHandler() {
        return nonApplicationRedirectHandler;
    }

    public GracefulShutdownFilter createGracefulShutdownHandler() {
        return new GracefulShutdownFilter();
    }

    private static void initializeVirtual(Vertx vertxRuntime) {
        if (virtualBootstrap != null) {
            return;
        }
        final VertxInternal vertx = (VertxInternal)vertxRuntime;
        virtualBootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)virtualBootstrap.group(vertx.getEventLoopGroup()).channel(VirtualServerChannel.class)).handler((ChannelHandler)new ChannelInitializer<VirtualServerChannel>(){

            public void initChannel(VirtualServerChannel ch) throws Exception {
            }
        })).childHandler((ChannelHandler)new ChannelInitializer<VirtualChannel>(){

            public void initChannel(VirtualChannel ch) throws Exception {
                ContextInternal context = vertx.createEventLoopContext(null, null, new JsonObject(), Thread.currentThread().getContextClassLoader());
                VertxHandler handler = VertxHandler.create((ContextInternal)context, chctx -> {
                    Http1xServerConnection conn = new Http1xServerConnection(context.owner(), null, new HttpServerOptions(), chctx, context, "localhost", null);
                    conn.handler(ACTUAL_ROOT);
                    return conn;
                });
                ch.pipeline().addLast("handler", (ChannelHandler)handler);
            }
        });
        try {
            virtualBootstrap.bind((java.net.SocketAddress)VIRTUAL_HTTP).sync();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("failed to bind virtual http");
        }
    }

    public static Handler<HttpServerRequest> getRootHandler() {
        return ACTUAL_ROOT;
    }

    public Handler<RoutingContext> createBodyHandler(HttpConfiguration httpConfiguration) {
        final BodyHandler bodyHandler = BodyHandler.create();
        Optional<MemorySize> maxBodySize = httpConfiguration.limits.maxBodySize;
        if (maxBodySize.isPresent()) {
            bodyHandler.setBodyLimit(maxBodySize.get().asLongValue());
        }
        BodyConfig bodyConfig = httpConfiguration.body;
        bodyHandler.setHandleFileUploads(bodyConfig.handleFileUploads);
        bodyHandler.setUploadsDirectory(bodyConfig.uploadsDirectory);
        bodyHandler.setDeleteUploadedFilesOnEnd(bodyConfig.deleteUploadedFilesOnEnd);
        bodyHandler.setMergeFormAttributes(bodyConfig.mergeFormAttributes);
        bodyHandler.setPreallocateBodyBuffer(bodyConfig.preallocateBodyBuffer);
        return new Handler<RoutingContext>(){

            public void handle(final RoutingContext event) {
                if (!Context.isOnEventLoopThread()) {
                    ((ConnectionBase)event.request().connection()).channel().eventLoop().execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (!event.request().isEnded()) {
                                    event.request().resume();
                                    if (CAN_HAVE_BODY.contains(event.request().method())) {
                                        bodyHandler.handle((Object)event);
                                    } else {
                                        event.next();
                                    }
                                } else {
                                    event.next();
                                }
                            }
                            catch (Throwable t) {
                                event.fail(t);
                            }
                        }
                    });
                } else {
                    event.request().resume();
                    if (CAN_HAVE_BODY.contains(event.request().method())) {
                        bodyHandler.handle((Object)event);
                    } else {
                        event.next();
                    }
                }
            }
        };
    }

    private BiConsumer<Cookie, HttpServerRequest> processSameSiteConfig(Map<String, SameSiteCookieConfig> httpConfiguration) {
        final ArrayList<18> functions = new ArrayList<18>();
        BiFunction<Cookie, HttpServerRequest, Boolean> last = null;
        for (final Map.Entry<String, SameSiteCookieConfig> entry : new TreeMap<String, SameSiteCookieConfig>(httpConfiguration).entrySet()) {
            final Pattern p = Pattern.compile(entry.getKey(), entry.getValue().caseSensitive ? 0 : 2);
            BiFunction<Cookie, HttpServerRequest, Boolean> biFunction = new BiFunction<Cookie, HttpServerRequest, Boolean>(){

                @Override
                public Boolean apply(Cookie cookie, HttpServerRequest request) {
                    if (p.matcher(cookie.getName()).matches()) {
                        if (((SameSiteCookieConfig)entry.getValue()).value == CookieSameSite.NONE) {
                            String userAgent;
                            if (((SameSiteCookieConfig)entry.getValue()).enableClientChecker && (userAgent = request.getHeader(HttpHeaders.USER_AGENT)) != null && SameSiteNoneIncompatibleClientChecker.isSameSiteNoneIncompatible(userAgent)) {
                                return false;
                            }
                            if (((SameSiteCookieConfig)entry.getValue()).addSecureForNone) {
                                cookie.setSecure(true);
                            }
                        }
                        cookie.setSameSite(((SameSiteCookieConfig)entry.getValue()).value);
                        return true;
                    }
                    return false;
                }
            };
            if (entry.getKey().equals(".*")) {
                last = biFunction;
                continue;
            }
            functions.add(biFunction);
        }
        if (last != null) {
            functions.add(last);
        }
        return new BiConsumer<Cookie, HttpServerRequest>(){

            @Override
            public void accept(Cookie cookie, HttpServerRequest request) {
                for (BiFunction i : functions) {
                    if (!((Boolean)i.apply(cookie, request)).booleanValue()) continue;
                    return;
                }
            }
        };
    }

    static {
        actualHttpPort = -1;
        actualHttpsPort = -1;
        ACTUAL_ROOT = new Handler<HttpServerRequest>(){

            public void handle(HttpServerRequest httpServerRequest) {
                Handler rh;
                if (httpServerRequest.absoluteURI() == null) {
                    httpServerRequest.response().setStatusCode(400).end();
                    return;
                }
                if (!httpServerRequest.rawMethod().equals(VertxHttpRecorder.GET)) {
                    httpServerRequest.pause();
                }
                if ((rh = rootHandler) != null) {
                    rh.handle((Object)httpServerRequest);
                } else {
                    httpServerRequest.resume();
                    httpServerRequest.response().setStatusCode(503).end();
                }
            }
        };
        VIRTUAL_HTTP = new VirtualAddress("netty-virtual-http");
        CAN_HAVE_BODY = Arrays.asList(HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH, HttpMethod.DELETE);
    }

    private static class WebDeploymentVerticle
    extends AbstractVerticle {
        private HttpServer httpServer;
        private HttpServer httpsServer;
        private HttpServer domainSocketServer;
        private final HttpServerOptions httpOptions;
        private final HttpServerOptions httpsOptions;
        private final HttpServerOptions domainSocketOptions;
        private final LaunchMode launchMode;
        private volatile boolean clearHttpProperty = false;
        private volatile boolean clearHttpsProperty = false;
        private volatile Map<String, String> portPropertiesToRestore;
        private final HttpConfiguration.InsecureRequests insecureRequests;

        public WebDeploymentVerticle(HttpServerOptions httpOptions, HttpServerOptions httpsOptions, HttpServerOptions domainSocketOptions, LaunchMode launchMode, HttpConfiguration.InsecureRequests insecureRequests) {
            this.httpOptions = httpOptions;
            this.httpsOptions = httpsOptions;
            this.launchMode = launchMode;
            this.domainSocketOptions = domainSocketOptions;
            this.insecureRequests = insecureRequests;
        }

        public void start(Future<Void> startFuture) {
            boolean httpServerEnabled;
            AtomicInteger remainingCount = new AtomicInteger(0);
            boolean bl = httpServerEnabled = this.httpOptions != null && this.insecureRequests != HttpConfiguration.InsecureRequests.DISABLED;
            if (httpServerEnabled) {
                remainingCount.incrementAndGet();
            }
            if (this.httpsOptions != null) {
                remainingCount.incrementAndGet();
            }
            if (this.domainSocketOptions != null) {
                remainingCount.incrementAndGet();
            }
            if (remainingCount.get() == 0) {
                startFuture.fail((Throwable)new IllegalArgumentException("Must configure at least one of http, https or unix domain socket"));
            }
            if (httpServerEnabled) {
                this.httpServer = this.vertx.createHttpServer(this.httpOptions);
                if (this.insecureRequests == HttpConfiguration.InsecureRequests.ENABLED) {
                    this.httpServer.requestHandler(ACTUAL_ROOT);
                } else {
                    this.httpServer.requestHandler((Handler)new Handler<HttpServerRequest>(){

                        public void handle(HttpServerRequest req) {
                            try {
                                String host = req.getHeader((CharSequence)HttpHeaderNames.HOST);
                                if (host == null) {
                                    req.response().setStatusCode(HttpResponseStatus.NOT_FOUND.code()).end();
                                } else {
                                    int includedPort = host.indexOf(":");
                                    if (includedPort != -1) {
                                        host = host.substring(0, includedPort);
                                    }
                                    req.response().setStatusCode(301).putHeader("Location", "https://" + host + ":" + httpsOptions.getPort() + req.uri()).end();
                                }
                            }
                            catch (Exception e) {
                                req.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end();
                            }
                        }
                    });
                }
                this.setupTcpHttpServer(this.httpServer, this.httpOptions, false, startFuture, remainingCount);
            }
            if (this.domainSocketOptions != null) {
                this.domainSocketServer = this.vertx.createHttpServer(this.domainSocketOptions);
                this.domainSocketServer.requestHandler(ACTUAL_ROOT);
                this.setupUnixDomainSocketHttpServer(this.domainSocketServer, this.domainSocketOptions, startFuture, remainingCount);
            }
            if (this.httpsOptions != null) {
                this.httpsServer = this.vertx.createHttpServer(this.httpsOptions);
                this.httpsServer.requestHandler(ACTUAL_ROOT);
                this.setupTcpHttpServer(this.httpsServer, this.httpsOptions, true, startFuture, remainingCount);
            }
        }

        private void setupUnixDomainSocketHttpServer(HttpServer httpServer, HttpServerOptions options, Future<Void> startFuture, AtomicInteger remainingCount) {
            httpServer.listen(SocketAddress.domainSocketAddress((String)options.getHost()), event -> {
                if (event.succeeded()) {
                    if (remainingCount.decrementAndGet() == 0) {
                        startFuture.complete(null);
                    }
                } else {
                    startFuture.fail(event.cause());
                }
            });
        }

        private void setupTcpHttpServer(HttpServer httpServer, HttpServerOptions options, boolean https, Future<Void> startFuture, AtomicInteger remainingCount) {
            httpServer.listen(options.getPort(), options.getHost(), event -> {
                if (event.cause() != null) {
                    startFuture.fail(event.cause());
                } else {
                    int actualPort = ((HttpServer)event.result()).actualPort();
                    if (actualPort != options.getPort()) {
                        String schema;
                        if (https) {
                            this.clearHttpsProperty = true;
                            schema = "https";
                        } else {
                            this.clearHttpProperty = true;
                            actualHttpPort = actualPort;
                            schema = "http";
                        }
                        this.portPropertiesToRestore = new HashMap<String, String>();
                        String portPropertyValue = String.valueOf(actualPort);
                        String portPropertyName = this.launchMode == LaunchMode.TEST ? "quarkus." + schema + ".test-port" : "quarkus." + schema + ".port";
                        String prevPortPropertyValue = System.setProperty(portPropertyName, portPropertyValue);
                        if (prevPortPropertyValue != null) {
                            this.portPropertiesToRestore.put(portPropertyName, prevPortPropertyValue);
                        }
                        if (this.launchMode.isDevOrTest() && (prevPortPropertyValue = System.setProperty(portPropertyName = this.propertyWithProfilePrefix(portPropertyName), portPropertyValue)) != null) {
                            this.portPropertiesToRestore.put(portPropertyName, prevPortPropertyValue);
                        }
                    }
                    if (https) {
                        actualHttpsPort = actualPort;
                    } else {
                        actualHttpPort = actualPort;
                    }
                    if (remainingCount.decrementAndGet() == 0) {
                        startFuture.complete(null);
                    }
                }
            });
        }

        public void stop(Future<Void> stopFuture) {
            String portPropertyName;
            if (this.clearHttpProperty) {
                portPropertyName = this.launchMode == LaunchMode.TEST ? "quarkus.http.test-port" : "quarkus.http.port";
                System.clearProperty(portPropertyName);
                if (this.launchMode.isDevOrTest()) {
                    System.clearProperty(this.propertyWithProfilePrefix(portPropertyName));
                }
            }
            if (this.clearHttpsProperty) {
                portPropertyName = this.launchMode == LaunchMode.TEST ? "quarkus.https.test-port" : "quarkus.https.port";
                System.clearProperty(portPropertyName);
                if (this.launchMode.isDevOrTest()) {
                    System.clearProperty(this.propertyWithProfilePrefix(portPropertyName));
                }
            }
            if (this.portPropertiesToRestore != null && !this.portPropertiesToRestore.isEmpty()) {
                System.getProperties().putAll(this.portPropertiesToRestore);
            }
            AtomicInteger remainingCount = new AtomicInteger(0);
            if (this.httpServer != null) {
                remainingCount.incrementAndGet();
            }
            if (this.httpsServer != null) {
                remainingCount.incrementAndGet();
            }
            if (this.domainSocketServer != null) {
                remainingCount.incrementAndGet();
            }
            Handler handleClose = event -> {
                if (remainingCount.decrementAndGet() == 0) {
                    stopFuture.complete();
                }
            };
            if (this.httpServer != null) {
                this.httpServer.close(handleClose);
            }
            if (this.httpsServer != null) {
                this.httpsServer.close(handleClose);
            }
            if (this.domainSocketServer != null) {
                this.domainSocketServer.close(handleClose);
            }
        }

        private String propertyWithProfilePrefix(String portPropertyName) {
            return "%" + this.launchMode.getDefaultProfile() + "." + portPropertyName;
        }
    }
}

