/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.quarkus.vertx.http.runtime.AbstractRequestWrapper;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;

class ResumingRequestWrapper
extends AbstractRequestWrapper {
    private boolean userSetState;

    ResumingRequestWrapper(HttpServerRequest request) {
        super(request);
    }

    @Override
    public HttpServerRequest handler(Handler<Buffer> handler) {
        this.delegate.handler(handler);
        if (!this.userSetState) {
            this.delegate.resume();
        }
        return this;
    }

    @Override
    public HttpServerRequest pause() {
        this.userSetState = true;
        this.delegate.pause();
        return this;
    }

    @Override
    public HttpServerRequest resume() {
        this.userSetState = true;
        this.delegate.resume();
        return this;
    }

    @Override
    public HttpServerRequest fetch(long amount) {
        this.userSetState = true;
        this.delegate.fetch(amount);
        return this;
    }

    @Override
    public HttpServerRequest endHandler(Handler<Void> handler) {
        this.delegate.endHandler(handler);
        if (!this.userSetState) {
            this.delegate.resume();
        }
        return this;
    }

    @Override
    public HttpServerRequest bodyHandler(Handler<Buffer> handler) {
        this.delegate.bodyHandler(handler);
        if (!this.userSetState) {
            this.delegate.resume();
        }
        return this;
    }

    @Override
    public HttpServerRequest uploadHandler(Handler<HttpServerFileUpload> handler) {
        this.delegate.uploadHandler(handler);
        if (!this.userSetState) {
            this.delegate.resume();
        }
        return this;
    }
}

