/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.logstream;

import io.quarkus.vertx.http.runtime.devmode.Json;
import java.io.IOException;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.LogRecord;
import org.jboss.logmanager.ExtFormatter;
import org.jboss.logmanager.ExtLogRecord;

public class JsonFormatter
extends ExtFormatter {
    private static final String TYPE = "type";
    private static final String LEVEL = "level";
    private static final String MESSAGE = "message";
    private static final String FORMATTED_MESSAGE = "formattedMessage";
    private static final String LOGGER_NAME_SHORT = "loggerNameShort";
    private static final String LOGGER_NAME = "loggerName";
    private static final String LOGGER_CLASS_NAME = "loggerClassName";
    private static final String HOST_NAME = "hostName";
    private static final String SOURCE_LINE_NUMBER = "sourceLineNumber";
    private static final String SOURCE_CLASS_NAME_FULL = "sourceClassNameFull";
    private static final String SOURCE_CLASS_NAME_FULL_SHORT = "sourceClassNameFullShort";
    private static final String SOURCE_CLASS_NAME = "sourceClassName";
    private static final String SOURCE_FILE_NAME = "sourceFileName";
    private static final String SOURCE_METHOD_NAME = "sourceMethodName";
    private static final String THREAD_ID = "threadId";
    private static final String THREAD_NAME = "threadName";
    private static final String PROCESS_ID = "processId";
    private static final String PROCESS_NAME = "processName";
    private static final String TIMESTAMP = "timestamp";
    private static final String STACKTRACE = "stacktrace";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final String DOT = ".";
    private static final String LOG_LINE = "logLine";

    public String format(ExtLogRecord logRecord) {
        return this.toJsonObject(logRecord).build();
    }

    private Json.JsonObjectBuilder toJsonObject(ExtLogRecord logRecord) {
        String formattedMessage = this.formatMessage((LogRecord)logRecord);
        Json.JsonObjectBuilder jsonObject = Json.object();
        jsonObject.put(TYPE, LOG_LINE);
        if (logRecord.getLoggerName() != null) {
            jsonObject.put(LOGGER_NAME_SHORT, this.getShortFullClassName(logRecord.getLoggerName(), ""));
            jsonObject.put(LOGGER_NAME, logRecord.getLoggerName());
        }
        if (logRecord.getLoggerClassName() != null) {
            jsonObject.put(LOGGER_CLASS_NAME, logRecord.getLoggerClassName());
        }
        if (logRecord.getHostName() != null) {
            jsonObject.put(HOST_NAME, logRecord.getHostName());
        }
        if (logRecord.getLevel() != null) {
            jsonObject.put(LEVEL, logRecord.getLevel().getName());
        }
        if (formattedMessage != null) {
            jsonObject.put(FORMATTED_MESSAGE, formattedMessage);
        }
        if (logRecord.getMessage() != null) {
            jsonObject.put(MESSAGE, logRecord.getMessage());
        }
        jsonObject.put(SOURCE_LINE_NUMBER, logRecord.getSourceLineNumber());
        if (logRecord.getSourceClassName() != null) {
            String justClassName = this.getJustClassName(logRecord.getSourceClassName());
            jsonObject.put(SOURCE_CLASS_NAME_FULL_SHORT, this.getShortFullClassName(logRecord.getSourceClassName(), justClassName));
            jsonObject.put(SOURCE_CLASS_NAME_FULL, logRecord.getSourceClassName());
            jsonObject.put(SOURCE_CLASS_NAME, justClassName);
        }
        if (logRecord.getSourceFileName() != null) {
            jsonObject.put(SOURCE_FILE_NAME, logRecord.getSourceFileName());
        }
        if (logRecord.getSourceMethodName() != null) {
            jsonObject.put(SOURCE_METHOD_NAME, logRecord.getSourceMethodName());
        }
        if (logRecord.getThrown() != null) {
            jsonObject.put(STACKTRACE, this.getStacktraces(logRecord.getThrown()));
        }
        jsonObject.put(THREAD_ID, logRecord.getThreadID());
        jsonObject.put(THREAD_NAME, logRecord.getThreadName());
        jsonObject.put(PROCESS_ID, logRecord.getProcessId());
        jsonObject.put(PROCESS_NAME, logRecord.getProcessName());
        jsonObject.put(TIMESTAMP, logRecord.getMillis());
        jsonObject.put(SEQUENCE_NUMBER, logRecord.getSequenceNumber());
        return jsonObject;
    }

    private Json.JsonArrayBuilder getStacktraces(Throwable t) {
        LinkedList<String> traces = new LinkedList<String>();
        this.addStacktrace(traces, t);
        Json.JsonArrayBuilder jsonArray = Json.array();
        traces.forEach(trace -> jsonArray.add((String)trace));
        return jsonArray;
    }

    private void addStacktrace(List<String> traces, Throwable t) {
        traces.add(this.getStacktrace(t));
        if (t.getCause() != null) {
            this.addStacktrace(traces, t.getCause());
        }
    }

    /*
     * Exception decompiling
     */
    private String getStacktrace(Throwable t) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getJustClassName(String fullName) {
        int lastDot = fullName.lastIndexOf(DOT) + 1;
        return fullName.substring(lastDot);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getShortFullClassName(String fullName, String justClassName) {
        String[] parts = fullName.split("\\.");
        try (StringWriter buffer = new StringWriter();){
            for (int i = 0; i < parts.length - 1; ++i) {
                String part = parts[i];
                if (part.equals(justClassName) || part.length() < 3) {
                    buffer.write(part);
                } else {
                    buffer.write(part.substring(0, 3));
                }
                buffer.write(DOT);
            }
            buffer.write(parts[parts.length - 1]);
            String string = buffer.toString();
            return string;
        }
        catch (IOException ex) {
            return fullName;
        }
    }
}

