/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import org.jboss.resteasy.reactive.common.core.Serialisers;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.spi.ServerHttpResponse;

public class StreamingUtil {
    public static CompletionStage<?> send(ResteasyReactiveRequestContext context, Object entity, String prefix) {
        byte[] data;
        ServerHttpResponse response = context.serverResponse();
        if (response.closed()) {
            return CompletableFuture.completedFuture(null);
        }
        try {
            data = StreamingUtil.serialiseEntity(context, entity);
        }
        catch (Exception e) {
            CompletableFuture ret = new CompletableFuture();
            ret.completeExceptionally(e);
            return ret;
        }
        StreamingUtil.setHeaders(context, response);
        if (prefix != null) {
            byte[] prefixBytes = prefix.getBytes(StandardCharsets.US_ASCII);
            byte[] prefixedData = new byte[prefixBytes.length + data.length];
            System.arraycopy(prefixBytes, 0, prefixedData, 0, prefixBytes.length);
            System.arraycopy(data, 0, prefixedData, prefixBytes.length, data.length);
            data = prefixedData;
        }
        return response.write(data);
    }

    private static byte[] serialiseEntity(ResteasyReactiveRequestContext context, Object entity) throws IOException {
        ServerSerialisers serialisers = context.getDeployment().getSerialisers();
        Class<?> entityClass = entity.getClass();
        Type entityType = context.getGenericReturnType();
        MediaType mediaType = context.getResponseMediaType();
        MessageBodyWriter<?>[] writers = serialisers.findWriters(null, entityClass, mediaType, RuntimeType.SERVER).toArray(ServerSerialisers.NO_WRITER);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean wrote = false;
        for (MessageBodyWriter<?> writer : writers) {
            if (!writer.isWriteable(entityClass, entityType, Serialisers.NO_ANNOTATION, mediaType)) continue;
            writer.writeTo(entity, entityClass, entityType, Serialisers.NO_ANNOTATION, mediaType, Serialisers.EMPTY_MULTI_MAP, (OutputStream)baos);
            wrote = true;
            break;
        }
        if (!wrote) {
            throw new IllegalStateException("Could not find MessageBodyWriter for " + entityClass + " / " + entityType + " as " + mediaType);
        }
        return baos.toByteArray();
    }

    public static void setHeaders(ResteasyReactiveRequestContext context, ServerHttpResponse response) {
        if (!response.headWritten()) {
            response.setStatusCode(Response.Status.OK.getStatusCode());
            response.setResponseHeader((CharSequence)"Content-Type", context.getResponseContentType().toString());
            response.setChunked(true);
        }
    }
}

