/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.jaxrs;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.reactive.server.core.Deployment;

public class ProvidersImpl
implements Providers {
    private final Deployment deployment;

    public ProvidersImpl(Deployment deployment) {
        this.deployment = deployment;
    }

    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        List readers = this.deployment.getSerialisers().findReaders(null, type, mediaType);
        for (MessageBodyReader reader : readers) {
            if (!reader.isReadable(type, genericType, annotations, mediaType)) continue;
            return reader;
        }
        return null;
    }

    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        List writers = this.deployment.getSerialisers().findWriters(null, type, mediaType, RuntimeType.SERVER);
        for (MessageBodyWriter writer : writers) {
            if (!writer.isWriteable(type, genericType, annotations, mediaType)) continue;
            return writer;
        }
        return null;
    }

    public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> type) {
        Map.Entry<Throwable, ExceptionMapper<Throwable>> entry = this.deployment.getExceptionMapping().getExceptionMapper(type, null, null);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public <T> ContextResolver<T> getContextResolver(Class<T> contextType, MediaType mediaType) {
        return this.deployment.getContextResolvers().getContextResolver(contextType, mediaType);
    }
}

