/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.h2.codecs;

import io.r2dbc.h2.codecs.AbstractCodec;
import io.r2dbc.h2.util.Assert;
import java.util.UUID;
import org.h2.value.Value;
import org.h2.value.ValueUuid;

final class UuidCodec
extends AbstractCodec<UUID> {
    UuidCodec() {
        super(UUID.class);
    }

    @Override
    boolean doCanDecode(int dataType) {
        return 20 == dataType;
    }

    @Override
    UUID doDecode(Value value, Class<? extends UUID> type) {
        return (UUID)value.convertTo(20).getObject();
    }

    @Override
    Value doEncode(UUID value) {
        return ValueUuid.get((UUID)Assert.requireNonNull(value, "value must not be null"));
    }
}

