/*
 * Decompiled with CFR 0.152.
 */
package ratpack.background.internal;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import ratpack.background.Background;
import ratpack.handling.Context;
import ratpack.util.Action;
import ratpack.util.ExceptionUtils;

public class DefaultBackground
implements Background {
    private final ExecutorService mainExecutor;
    private final ListeningExecutorService backgroundExecutor;
    private final Context context;

    public DefaultBackground(ExecutorService mainExecutor, ListeningExecutorService backgroundExecutor, Context context) {
        this.mainExecutor = mainExecutor;
        this.backgroundExecutor = backgroundExecutor;
        this.context = context;
    }

    @Override
    public <T> Background.SuccessOrError<T> exec(Callable<T> operation) {
        return new DefaultSuccessOrError<T>(operation);
    }

    private class DefaultSuccess<T>
    implements Background.Success<T> {
        private final Callable<T> backgroundAction;
        private final Action<Throwable> errorHandler;

        DefaultSuccess(Callable<T> backgroundAction, Action<Throwable> errorHandler) {
            this.backgroundAction = backgroundAction;
            this.errorHandler = errorHandler;
        }

        @Override
        public void then(final Action<? super T> then) {
            ListenableFuture future = DefaultBackground.this.backgroundExecutor.submit(this.backgroundAction);
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<T>(){

                public void onSuccess(T result) {
                    try {
                        then.execute(result);
                    }
                    catch (Exception e) {
                        DefaultBackground.this.context.error(e);
                    }
                }

                public void onFailure(Throwable t) {
                    try {
                        DefaultSuccess.this.errorHandler.execute(t);
                    }
                    catch (Exception e) {
                        DefaultBackground.this.context.error(e);
                    }
                }
            }, (Executor)DefaultBackground.this.mainExecutor);
        }
    }

    private class DefaultSuccessOrError<T>
    implements Background.SuccessOrError<T> {
        private final Callable<T> backgroundAction;

        DefaultSuccessOrError(Callable<T> backgroundAction) {
            this.backgroundAction = backgroundAction;
        }

        @Override
        public Background.Success<T> onError(final Action<? super Throwable> errorHandler) {
            return new DefaultSuccess<T>(this.backgroundAction, new Action<Throwable>(){

                @Override
                public void execute(Throwable t) {
                    try {
                        errorHandler.execute(t);
                    }
                    catch (Throwable errorHandlerError) {
                        new ForwardToContextErrorHandler().execute(errorHandlerError);
                    }
                }
            });
        }

        @Override
        public void then(Action<? super T> then) {
            new DefaultSuccess<T>(this.backgroundAction, new ForwardToContextErrorHandler()).then(then);
        }

        class ForwardToContextErrorHandler
        implements Action<Throwable> {
            ForwardToContextErrorHandler() {
            }

            @Override
            public void execute(Throwable t) {
                DefaultBackground.this.context.error(ExceptionUtils.toException(t));
            }
        }
    }
}

