/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedNioStream;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.FileInputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.Callable;
import ratpack.background.Background;
import ratpack.file.internal.FileHttpTransmitter;
import ratpack.util.Action;

public class DefaultFileHttpTransmitter
implements FileHttpTransmitter {
    private final HttpRequest request;
    private final HttpResponse response;
    private final Channel channel;

    public DefaultFileHttpTransmitter(HttpRequest request, HttpResponse response, Channel channel) {
        this.request = request;
        this.response = response;
        this.channel = channel;
    }

    @Override
    public void transmit(Background background, final BasicFileAttributes basicFileAttributes, final Path file) {
        if (file.getFileSystem().equals(FileSystems.getDefault())) {
            background.exec(new Callable<FileChannel>(){

                @Override
                public FileChannel call() throws Exception {
                    return new FileInputStream(file.toFile()).getChannel();
                }
            }).then(new Action<FileChannel>(){

                @Override
                public void execute(FileChannel fileChannel) {
                    DefaultFileRegion defaultFileRegion = new DefaultFileRegion(fileChannel, 0L, basicFileAttributes.size());
                    DefaultFileHttpTransmitter.this.transmit(basicFileAttributes, defaultFileRegion);
                }
            });
        } else {
            background.exec(new Callable<ReadableByteChannel>(){

                @Override
                public ReadableByteChannel call() throws Exception {
                    return Files.newByteChannel(file, new OpenOption[0]);
                }
            }).then(new Action<ReadableByteChannel>(){

                @Override
                public void execute(ReadableByteChannel fileChannel) {
                    DefaultFileHttpTransmitter.this.transmit(basicFileAttributes, new ChunkedNioStream(fileChannel));
                }
            });
        }
    }

    private void transmit(BasicFileAttributes basicFileAttributes, Object message) {
        this.response.headers().set("Content-Length", (Object)basicFileAttributes.size());
        if (HttpHeaders.isKeepAlive((HttpMessage)this.request)) {
            this.response.headers().set("Connection", (Object)"keep-alive");
        }
        DefaultHttpResponse minimalResponse = new DefaultHttpResponse(this.response.getProtocolVersion(), this.response.getStatus());
        minimalResponse.headers().set(this.response.headers());
        ChannelFuture writeFuture = this.channel.writeAndFlush((Object)minimalResponse);
        writeFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    DefaultFileHttpTransmitter.this.channel.close();
                }
            }
        });
        writeFuture = this.channel.write(message);
        writeFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                if (!future.isSuccess()) {
                    DefaultFileHttpTransmitter.this.channel.close();
                }
            }
        });
        ChannelFuture lastContentFuture = this.channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (!HttpHeaders.isKeepAlive((HttpMessage)this.response)) {
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

