/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file.internal;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.concurrent.Callable;
import ratpack.background.Background;
import ratpack.file.FileRenderer;
import ratpack.file.MimeTypes;
import ratpack.handling.Context;
import ratpack.render.RendererSupport;
import ratpack.util.Action;

public class DefaultFileRenderer
extends RendererSupport<Path>
implements FileRenderer {
    @Override
    public void render(final Context context, final Path targetFile) {
        DefaultFileRenderer.readAttributes(context.getBackground(), targetFile, (Action<? super BasicFileAttributes>)new Action<BasicFileAttributes>(){

            @Override
            public void execute(BasicFileAttributes attributes) {
                if (attributes == null || !attributes.isRegularFile()) {
                    context.clientError(404);
                } else {
                    DefaultFileRenderer.sendFile(context, targetFile, attributes);
                }
            }
        });
    }

    public static void sendFile(final Context context, final Path file, final BasicFileAttributes attributes) {
        if (!context.getRequest().getMethod().isGet()) {
            context.clientError(405);
            return;
        }
        Date date = new Date(attributes.lastModifiedTime().toMillis());
        context.lastModified(date, new Runnable(){

            @Override
            public void run() {
                String ifNoneMatch = context.getRequest().getHeaders().get("If-None-Match");
                if (ifNoneMatch != null && ifNoneMatch.trim().equals("*")) {
                    context.getResponse().status(HttpResponseStatus.NOT_MODIFIED.code(), HttpResponseStatus.NOT_MODIFIED.reasonPhrase()).send();
                    return;
                }
                String contentType = context.get(MimeTypes.class).getContentType(file.getFileName().toString());
                context.getResponse().sendFile(context.getBackground(), contentType, attributes, file);
            }
        });
    }

    public static void readAttributes(Background background, final Path file, Action<? super BasicFileAttributes> then) {
        background.exec(new Callable<BasicFileAttributes>(){

            @Override
            public BasicFileAttributes call() throws Exception {
                if (Files.exists(file, new LinkOption[0])) {
                    return Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
                }
                return null;
            }
        }).then(then);
    }
}

