/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import com.google.common.util.concurrent.ListeningExecutorService;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Logger;
import ratpack.background.Background;
import ratpack.background.internal.DefaultBackground;
import ratpack.error.ClientErrorHandler;
import ratpack.error.ServerErrorHandler;
import ratpack.event.internal.EventRegistry;
import ratpack.file.FileSystemBinding;
import ratpack.handling.ByContentHandler;
import ratpack.handling.ByMethodHandler;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.Redirector;
import ratpack.handling.RequestOutcome;
import ratpack.handling.direct.DirectChannelAccess;
import ratpack.handling.internal.DefaultByContentHandler;
import ratpack.handling.internal.DefaultByMethodHandler;
import ratpack.handling.internal.HandlerException;
import ratpack.http.Request;
import ratpack.http.Response;
import ratpack.http.internal.ByteBufBackedRequestBody;
import ratpack.parse.Parse;
import ratpack.parse.Parser;
import ratpack.path.PathBinding;
import ratpack.path.PathTokens;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.Registry;
import ratpack.registry.RegistryBuilder;
import ratpack.render.NoSuchRendererException;
import ratpack.render.Renderer;
import ratpack.server.BindAddress;
import ratpack.util.Action;
import ratpack.util.ExceptionUtils;
import ratpack.util.Factory;
import ratpack.util.Result;
import ratpack.util.ResultAction;

public class DefaultContext
implements Context {
    private static final Logger LOGGER = Logger.getLogger(Context.class.getName());
    private final DirectChannelAccess directChannelAccess;
    private final Request request;
    private final Response response;
    private final ScheduledExecutorService foregroundExecutorService;
    private final ListeningExecutorService backgroundExecutorService;
    private final Registry registry;
    private final BindAddress bindAddress;
    private final EventRegistry<RequestOutcome> onCloseRegistry;
    private final Handler[] nextHandlers;
    private final int nextIndex;
    private final Handler exhausted;

    public DefaultContext(DirectChannelAccess directChannelAccess, Request request, Response response, BindAddress bindAddress, Registry registry, ListeningExecutorService backgroundExecutorService, ScheduledExecutorService foregroundExecutorService, EventRegistry<RequestOutcome> onCloseRegistry, Handler[] nextHandlers, int nextIndex, Handler exhausted) {
        this.directChannelAccess = directChannelAccess;
        this.request = request;
        this.response = response;
        this.bindAddress = bindAddress;
        this.registry = registry;
        this.backgroundExecutorService = backgroundExecutorService;
        this.foregroundExecutorService = foregroundExecutorService;
        this.onCloseRegistry = onCloseRegistry;
        this.nextHandlers = nextHandlers;
        this.nextIndex = nextIndex;
        this.exhausted = exhausted;
    }

    @Override
    public Context getContext() {
        return this;
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public Response getResponse() {
        return this.response;
    }

    @Override
    public <O> O get(Class<O> type) throws NotInRegistryException {
        return this.registry.get(type);
    }

    @Override
    public <O> List<O> getAll(Class<O> type) {
        return this.registry.getAll(type);
    }

    @Override
    public <O> O maybeGet(Class<O> type) {
        return this.registry.maybeGet(type);
    }

    @Override
    public void next() {
        this.doNext(this, this.registry, this.nextIndex, this.nextHandlers, this.exhausted);
    }

    @Override
    public void next(Registry registry) {
        this.doNext(this, RegistryBuilder.join(this.registry, registry), this.nextIndex, this.nextHandlers, this.exhausted);
    }

    @Override
    public <T> void next(Class<T> publicType, Factory<? extends T> factory) {
        this.next(RegistryBuilder.builder().add(publicType, factory).build());
    }

    @Override
    public void next(Object object) {
        this.next(RegistryBuilder.builder().add(object).build());
    }

    @Override
    public <P, T extends P> void next(Class<P> publicType, T impl) {
        this.next(RegistryBuilder.builder().add(publicType, impl).build());
    }

    @Override
    public void insert(Handler ... handlers) {
        if (handlers.length == 0) {
            throw new IllegalArgumentException("handlers is zero length");
        }
        this.doNext(this, this.registry, 0, handlers, new RejoinHandler());
    }

    @Override
    public void insert(Registry registry, Handler ... handlers) {
        if (handlers.length == 0) {
            throw new IllegalArgumentException("handlers is zero length");
        }
        this.doNext(this, RegistryBuilder.join(this.registry, registry), 0, handlers, new RejoinHandler());
    }

    @Override
    public <T> void insert(Class<T> publicType, Factory<? extends T> factory, Handler ... handlers) {
        if (handlers.length == 0) {
            throw new IllegalArgumentException("handlers is zero length");
        }
        this.insert(RegistryBuilder.builder().add(publicType, factory).build(), handlers);
    }

    @Override
    public <P, T extends P> void insert(Class<P> publicType, T implementation, Handler ... handlers) {
        if (handlers.length == 0) {
            throw new IllegalArgumentException("handlers is zero length");
        }
        this.insert(RegistryBuilder.builder().add(publicType, implementation).build(), handlers);
    }

    @Override
    public void insert(Object object, Handler ... handlers) {
        if (handlers.length == 0) {
            throw new IllegalArgumentException("handlers is zero length");
        }
        this.insert(RegistryBuilder.builder().add(object).build(), handlers);
    }

    @Override
    public void respond(Handler handler) {
        try {
            handler.handle(this);
        }
        catch (Exception e) {
            this.dispatchException(e);
        }
    }

    @Override
    public PathTokens getPathTokens() {
        return this.get(PathBinding.class).getTokens();
    }

    @Override
    public PathTokens getAllPathTokens() {
        return this.get(PathBinding.class).getAllTokens();
    }

    @Override
    public Path file(String path) {
        return this.get(FileSystemBinding.class).file(path);
    }

    @Override
    public void render(Object object) throws NoSuchRendererException {
        if (object == null) {
            this.clientError(404);
            return;
        }
        List<Renderer> all = this.registry.getAll(Renderer.class);
        for (Renderer renderer : all) {
            if (!this.maybeRender(object, renderer)) continue;
            return;
        }
        throw new NoSuchRendererException("No renderer for object '" + object + "' of type '" + object.getClass() + "'");
    }

    private <T> boolean maybeRender(Object object, Renderer<T> renderer) {
        if (renderer.getType().isInstance(object)) {
            Object cast = object;
            try {
                renderer.render(this, cast);
            }
            catch (Exception e) {
                this.error(e);
            }
            return true;
        }
        return false;
    }

    @Override
    public <T> T parse(Parse<T> parse) {
        List<Parser> all = this.registry.getAll(Parser.class);
        String requestContentType = this.request.getContentType().getType();
        if (requestContentType == null) {
            requestContentType = "text/plain";
        }
        for (Parser parser : all) {
            Object parsed = this.maybeParse(requestContentType, parse, parser);
            if (parsed == null) continue;
            return (T)parsed;
        }
        throw new RuntimeException("No parser for " + parse + " and content type " + requestContentType);
    }

    @Override
    public void onClose(Action<? super RequestOutcome> callback) {
        this.onCloseRegistry.register(callback);
    }

    @Override
    public DirectChannelAccess getDirectChannelAccess() {
        return this.directChannelAccess;
    }

    private <P, S extends Parse<P>> P maybeParse(String requestContentType, S parseSpec, Parser<?, ?> parser) {
        if (requestContentType.equalsIgnoreCase(parser.getContentType()) && parser.getParseType().isInstance(parseSpec)) {
            Parser<?, ?> castParser = parser;
            ByteBufBackedRequestBody requestBody = new ByteBufBackedRequestBody(this.getRequest(), this.getRequest().getBuffer());
            return (P)castParser.parse(this, requestBody, parseSpec);
        }
        return null;
    }

    @Override
    public Background getBackground() {
        return new DefaultBackground(this.foregroundExecutorService, this.backgroundExecutorService, this);
    }

    @Override
    public <T> Background.SuccessOrError<T> background(Callable<T> backgroundOperation) {
        return this.getBackground().exec(backgroundOperation);
    }

    @Override
    public ScheduledExecutorService getForegroundExecutorService() {
        return this.foregroundExecutorService;
    }

    @Override
    public void redirect(String location) {
        this.redirect(HttpResponseStatus.FOUND.code(), location);
    }

    @Override
    public void redirect(int code, String location) {
        Redirector redirector = this.registry.get(Redirector.class);
        redirector.redirect(this, location, code);
    }

    @Override
    public void lastModified(Date date, Runnable runnable) {
        long time;
        long ifModifiedSinceSecs;
        Date ifModifiedSinceHeader = this.request.getHeaders().getDate("If-Modified-Since");
        long lastModifiedSecs = date.getTime() / 1000L;
        if (ifModifiedSinceHeader != null && lastModifiedSecs == (ifModifiedSinceSecs = (time = ifModifiedSinceHeader.getTime()) / 1000L)) {
            this.response.status(HttpResponseStatus.NOT_MODIFIED.code(), HttpResponseStatus.NOT_MODIFIED.reasonPhrase()).send();
            return;
        }
        this.response.getHeaders().setDate("Last-Modified", date);
        runnable.run();
    }

    @Override
    public BindAddress getBindAddress() {
        return this.bindAddress;
    }

    @Override
    public void error(Exception exception) {
        ServerErrorHandler serverErrorHandler = this.get(ServerErrorHandler.class);
        Exception unpacked = this.unpackException(exception);
        try {
            serverErrorHandler.error(this, unpacked);
        }
        catch (Exception errorHandlerException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            stringWriter.append("Exception thrown by error handler ").append(serverErrorHandler.toString()).append(" while handling exception\nOriginal exception: ");
            unpacked.printStackTrace(printWriter);
            stringWriter.append("Error handler exception: ");
            errorHandlerException.printStackTrace(printWriter);
            LOGGER.warning(stringWriter.toString());
            this.response.status(500).send();
        }
    }

    private Exception unpackException(Exception exception) {
        if (exception instanceof UndeclaredThrowableException) {
            return ExceptionUtils.toException(exception.getCause());
        }
        return exception;
    }

    @Override
    public void clientError(int statusCode) {
        try {
            this.get(ClientErrorHandler.class).error(this, statusCode);
        }
        catch (Exception e) {
            this.dispatchException(e);
        }
    }

    @Override
    public void withErrorHandling(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            this.dispatchException(e);
        }
    }

    private void dispatchException(Exception e) {
        if (e instanceof HandlerException) {
            ((HandlerException)e).getContext().error((Exception)e.getCause());
        } else {
            this.error(e);
        }
    }

    @Override
    public <T> ResultAction<T> resultAction(final Action<T> action) {
        return new ResultAction<T>(){

            @Override
            public void execute(Result<T> result) {
                if (result.isFailure()) {
                    DefaultContext.this.dispatchException(result.getFailure());
                } else {
                    try {
                        action.execute(result.getValue());
                    }
                    catch (Exception e) {
                        DefaultContext.this.dispatchException(e);
                    }
                }
            }
        };
    }

    @Override
    public ByMethodHandler getByMethod() {
        return new DefaultByMethodHandler();
    }

    @Override
    public ByContentHandler getByContent() {
        return new DefaultByContentHandler();
    }

    protected void doNext(Context parentContext, Registry registry, int nextIndex, Handler[] nextHandlers, Handler exhausted) {
        Handler handler;
        Context context;
        if (nextIndex >= nextHandlers.length) {
            context = parentContext;
            handler = exhausted;
        } else {
            handler = nextHandlers[nextIndex];
            context = this.createContext(registry, nextHandlers, nextIndex + 1, exhausted);
        }
        try {
            handler.handle(context);
        }
        catch (Exception e) {
            if (e instanceof HandlerException) {
                throw (HandlerException)e;
            }
            throw new HandlerException(context, e);
        }
    }

    private DefaultContext createContext(Registry registry, Handler[] nextHandlers, int nextIndex, Handler exhausted) {
        return new DefaultContext(this.directChannelAccess, this.request, this.response, this.bindAddress, registry, this.backgroundExecutorService, this.foregroundExecutorService, this.onCloseRegistry, nextHandlers, nextIndex, exhausted);
    }

    private class RejoinHandler
    implements Handler {
        private RejoinHandler() {
        }

        @Override
        public void handle(Context context) throws Exception {
            DefaultContext.this.doNext(DefaultContext.this, DefaultContext.this.registry, DefaultContext.this.nextIndex, DefaultContext.this.nextHandlers, DefaultContext.this.exhausted);
        }
    }
}

