/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import ratpack.http.Request;
import ratpack.http.RequestBody;
import ratpack.util.ExceptionUtils;

public class ByteBufBackedRequestBody
implements RequestBody {
    private final Request request;
    private final ByteBuf byteBuf;

    public ByteBufBackedRequestBody(Request request, ByteBuf byteBuf) {
        this.request = request;
        this.byteBuf = byteBuf;
    }

    @Override
    public ByteBuf getBuffer() {
        return this.byteBuf;
    }

    @Override
    public String getText() {
        return this.byteBuf.toString(Charset.forName(this.request.getContentType().getCharset()));
    }

    @Override
    public byte[] getBytes() {
        if (this.byteBuf.hasArray()) {
            return this.byteBuf.array();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.byteBuf.writerIndex());
        try {
            this.writeTo(baos);
        }
        catch (IOException e) {
            throw ExceptionUtils.uncheck(e);
        }
        return baos.toByteArray();
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        this.byteBuf.resetReaderIndex();
        this.byteBuf.readBytes(outputStream, this.byteBuf.writerIndex());
    }

    @Override
    public InputStream getInputStream() {
        return new ByteBufInputStream(this.byteBuf);
    }
}

