/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import io.netty.handler.codec.http.HttpHeaders;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import ratpack.http.Headers;
import ratpack.http.internal.HttpHeaderDateFormat;

public class NettyHeadersBackedHeaders
implements Headers {
    protected final HttpHeaders headers;

    public NettyHeadersBackedHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    @Override
    public String get(String name) {
        return this.headers.get(name);
    }

    @Override
    public Date getDate(String name) {
        String value = this.get(name);
        if (value == null) {
            return null;
        }
        try {
            return HttpHeaderDateFormat.get().parse(value);
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Override
    public List<String> getAll(String name) {
        return this.headers.getAll(name);
    }

    @Override
    public boolean contains(String name) {
        return this.headers.contains(name);
    }

    @Override
    public Set<String> getNames() {
        return this.headers.names();
    }
}

