/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry;

import com.google.common.collect.ImmutableList;
import ratpack.registry.Registry;
import ratpack.registry.internal.CachingRegistry;
import ratpack.registry.internal.DefaultRegistry;
import ratpack.registry.internal.DefaultRegistryEntry;
import ratpack.registry.internal.HierarchicalRegistry;
import ratpack.registry.internal.LazyRegistryEntry;
import ratpack.registry.internal.RegistryEntry;
import ratpack.util.Factory;

public class RegistryBuilder {
    private final ImmutableList.Builder<RegistryEntry<?>> builder = ImmutableList.builder();

    private RegistryBuilder() {
    }

    public static RegistryBuilder builder() {
        return new RegistryBuilder();
    }

    public <O> RegistryBuilder add(Class<O> type, O object) {
        this.builder.add(new DefaultRegistryEntry<O>(type, object));
        return this;
    }

    public <O> RegistryBuilder add(O object) {
        Class<?> cast = object.getClass();
        return this.add(cast, object);
    }

    public <O> RegistryBuilder add(Class<O> type, Factory<? extends O> object) {
        this.builder.add(new LazyRegistryEntry<O>(type, object));
        return this;
    }

    public Registry build() {
        return new CachingRegistry(new DefaultRegistry(this.builder.build()));
    }

    public Registry build(Registry parent) {
        return RegistryBuilder.join(parent, new DefaultRegistry(this.builder.build()));
    }

    public static Registry join(Registry parent, Registry child) {
        return new CachingRegistry(new HierarchicalRegistry(parent, child));
    }
}

