/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import ratpack.server.BindAddress;

public class InetSocketAddressBackedBindAddress
implements BindAddress {
    private final int port;
    private final String host;

    public InetSocketAddressBackedBindAddress(InetSocketAddress socketAddress) {
        this.port = socketAddress.getPort();
        this.host = InetSocketAddressBackedBindAddress.determineHost(socketAddress);
    }

    public static String determineHost(InetSocketAddress socketAddress) {
        InetAddress address = socketAddress.getAddress();
        String hostAddress = address.getHostAddress();
        if (address.isAnyLocalAddress() || hostAddress.equals("127.0.0.1")) {
            return "localhost";
        }
        return hostAddress;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getHost() {
        return this.host;
    }
}

