/*
 * Decompiled with CFR 0.152.
 */
package ratpack.util.internal;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import ratpack.http.MediaType;
import ratpack.util.ExceptionUtils;

public abstract class BufferUtil {
    public static String getText(ByteBuf byteBuf, String charset) {
        return byteBuf.toString(Charset.forName(charset));
    }

    public static String getText(ByteBuf byteBuf, MediaType mediaType) {
        return BufferUtil.getText(byteBuf, mediaType.getCharset());
    }

    public static byte[] getBytes(ByteBuf byteBuf) {
        if (byteBuf.hasArray()) {
            return byteBuf.array();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(byteBuf.writerIndex());
        try {
            BufferUtil.writeTo(byteBuf, baos);
        }
        catch (IOException e) {
            throw ExceptionUtils.uncheck(e);
        }
        return baos.toByteArray();
    }

    public static void writeTo(ByteBuf byteBuf, OutputStream outputStream) throws IOException {
        byteBuf.resetReaderIndex();
        byteBuf.readBytes(outputStream, byteBuf.writerIndex());
    }
}

