/*
 * Decompiled with CFR 0.152.
 */
package ratpack.util.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public abstract class IoUtils {
    public static ByteBuf read(Path path) throws IOException {
        try (SeekableByteChannel seekableByteChannel = Files.newByteChannel(path, new OpenOption[0]);){
            ByteBuf byteBuf = IoUtils.read(seekableByteChannel);
            return byteBuf;
        }
    }

    public static ByteBuf read(File file) throws IOException {
        try (FileInputStream fIn = new FileInputStream(file);){
            ByteBuf byteBuf = IoUtils.read(fIn.getChannel());
            return byteBuf;
        }
    }

    private static ByteBuf read(SeekableByteChannel fChan) throws IOException {
        long fSize = fChan.size();
        ByteBuffer mBuf = ByteBuffer.allocate((int)fSize);
        fChan.read(mBuf);
        mBuf.rewind();
        return Unpooled.wrappedBuffer((ByteBuffer)mBuf);
    }

    public static ByteBuf utf8Buffer(String str) {
        return Unpooled.copiedBuffer((CharSequence)str, (Charset)CharsetUtil.UTF_8);
    }

    public static byte[] utf8Bytes(String str) {
        return str.getBytes(CharsetUtil.UTF_8);
    }

    public static String utf8String(ByteBuf byteBuf) {
        return byteBuf.toString(CharsetUtil.UTF_8);
    }

    public static ByteBuf byteBuf(byte[] bytes) {
        return Unpooled.wrappedBuffer((byte[])bytes);
    }

    public static void writeTo(InputStream inputStream, ByteBuf byteBuf) throws IOException {
        byte[] bytes = new byte[1024];
        int read = inputStream.read(bytes);
        while (read > 0) {
            byteBuf.writeBytes(bytes, 0, read);
            read = inputStream.read(bytes);
        }
        inputStream.close();
    }
}

