/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec;

import ratpack.exec.internal.DefaultResult;
import ratpack.util.Exceptions;

public interface Result<T> {
    public static <T> Result<T> success(T value) {
        return new DefaultResult<T>(value);
    }

    public static <T> Result<T> error(Throwable error) {
        return new DefaultResult(error);
    }

    public Throwable getThrowable();

    public T getValue();

    public boolean isSuccess();

    public boolean isError();

    default public T getValueOrThrow() throws Exception {
        if (this.isError()) {
            throw Exceptions.toException(this.getThrowable());
        }
        return this.getValue();
    }
}

