/*
 * Decompiled with CFR 0.152.
 */
package ratpack.func;

import ratpack.exec.Operation;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.util.Exceptions;

@FunctionalInterface
public interface Block {
    public static Block noop() {
        return () -> {};
    }

    public void execute() throws Exception;

    public static Block throwException(Throwable throwable) {
        return () -> {
            throw Exceptions.toException(throwable);
        };
    }

    default public Runnable toRunnable() {
        return () -> Exceptions.uncheck(this);
    }

    @Deprecated
    default public Operation operation() {
        return Operation.of(this);
    }

    default public Action<Object> action() {
        return t -> this.execute();
    }

    default public <T> T map(Function<? super Block, ? extends T> function) {
        return Exceptions.uncheck(() -> function.apply(this));
    }
}

