/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.components.impl;

import com.google.common.base.Joiner;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

class GroovyExtensionCombiner {
    private GroovyExtensionCombiner() {
    }

    static List<String> merge(String projectName, String projectVersion, List<String> local, List<List<String>> deps) {
        ArrayList<String> extensionClassesList = new ArrayList<String>();
        ArrayList<String> staticExtensionClassesList = new ArrayList<String>();
        ArrayList<Properties> all = new ArrayList<Properties>();
        all.add(GroovyExtensionCombiner.asProperties(local));
        if (deps != null) {
            deps.forEach(s -> all.add(GroovyExtensionCombiner.asProperties(s)));
        }
        for (Properties properties : all) {
            String staticExtensionClasses = properties.getProperty("staticExtensionClasses", "").trim();
            String extensionClasses = properties.getProperty("extensionClasses", "").trim();
            if (extensionClasses.length() > 0) {
                GroovyExtensionCombiner.append(extensionClasses, extensionClassesList);
            }
            if (staticExtensionClasses.length() <= 0) continue;
            GroovyExtensionCombiner.append(staticExtensionClasses, staticExtensionClassesList);
        }
        ArrayList<String> desc = new ArrayList<String>();
        desc.add("moduleName=" + projectName);
        desc.add("moduleVersion=" + projectVersion);
        if (!extensionClassesList.isEmpty()) {
            desc.add("extensionClasses=" + GroovyExtensionCombiner.join(extensionClassesList));
        }
        if (!staticExtensionClassesList.isEmpty()) {
            desc.add("staticExtensionClasses=" + GroovyExtensionCombiner.join(staticExtensionClassesList));
        }
        return desc;
    }

    private static void append(String entry, List<String> list) {
        if (entry != null) {
            Collections.addAll(list, entry.split("\\s*,\\s*"));
        }
    }

    private static String join(List<String> strings) {
        return Joiner.on((String)",").join(strings);
    }

    private static Properties asProperties(List<String> lines) {
        byte[] content = GroovyExtensionCombiner.read(lines);
        Properties properties = new Properties();
        if (content.length != 0) {
            try (ByteArrayInputStream stream = new ByteArrayInputStream(content);){
                properties.load(stream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return properties;
    }

    private static byte[] read(List<String> lines) {
        if (lines == null || lines.isEmpty()) {
            return new byte[0];
        }
        StringBuilder buffer = new StringBuilder();
        for (String l : lines) {
            buffer.append(l).append("\n");
        }
        return buffer.toString().getBytes();
    }
}

