/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.components.impl;

import io.reactiverse.vertx.maven.plugin.components.Prompter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import jline.console.ConsoleReader;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=Prompter.class, instantiationStrategy="per-lookup")
public class PrompterImpl
implements Prompter {
    private final ConsoleReader console;

    public PrompterImpl() throws IOException {
        this.console = new ConsoleReader();
        this.console.setHistoryEnabled(false);
        this.console.setExpandEvents(false);
    }

    public PrompterImpl(InputStream in, OutputStream out) throws IOException {
        this.console = new ConsoleReader(in, out);
        this.console.setHistoryEnabled(false);
        this.console.setExpandEvents(false);
    }

    public ConsoleReader getConsole() {
        return this.console;
    }

    public String prompt(String message, Character mask) throws IOException {
        String value;
        Objects.requireNonNull(message);
        String prompt = String.format("%s: ", message);
        while (StringUtils.isBlank((CharSequence)(value = this.console.readLine(prompt, mask)))) {
        }
        return value;
    }

    @Override
    public String prompt(String message) throws IOException {
        Objects.requireNonNull(message);
        return this.prompt(message, null);
    }

    @Override
    public String promptWithDefaultValue(String message, String defaultValue) throws IOException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(defaultValue);
        String prompt = String.format("%s [%s]: ", message, defaultValue);
        String value = this.console.readLine(prompt);
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        return value;
    }
}

