/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.mojos;

import com.google.common.base.Strings;
import io.reactiverse.vertx.maven.plugin.components.Prompter;
import io.reactiverse.vertx.maven.plugin.dependencies.VertxDependencies;
import io.reactiverse.vertx.maven.plugin.dependencies.VertxDependency;
import io.reactiverse.vertx.maven.plugin.utils.MojoUtils;
import io.reactiverse.vertx.maven.plugin.utils.SetupTemplateUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="setup", requiresProject=false)
public class SetupMojo
extends AbstractMojo {
    public static final String JAVA_EXTENSION = ".java";
    public static final String VERTX_CORE_VERSION = "vertx-core-version";
    public static final String VERTX_GROUP_ID = "io.vertx";
    private final String PLUGIN_GROUPID = "io.reactiverse";
    private final String PLUGIN_ARTIFACTID = "vertx-maven-plugin";
    private final String VERTX_MAVEN_PLUGIN_VERSION_PROPERTY = "vertx-maven-plugin-version";
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(property="projectGroupId")
    protected String projectGroupId;
    @Parameter(property="projectArtifactId")
    protected String projectArtifactId;
    @Parameter(property="projectVersion", defaultValue="1.0-SNAPSHOT")
    protected String projectVersion;
    @Parameter(property="vertxVersion")
    protected String vertxVersion;
    @Parameter(property="verticle")
    protected String verticle;
    @Parameter(property="dependencies")
    protected List<String> dependencies;
    @Component
    protected Prompter prompter;

    public void execute() throws MojoExecutionException {
        File pomFile = this.project.getFile();
        if (pomFile == null || !pomFile.isFile()) {
            pomFile = this.createPomFileFromUserInputs();
        }
        Model model = this.project.getOriginalModel().clone();
        this.createDirectories();
        SetupTemplateUtils.createVerticle(this.project, this.verticle, this.getLog());
        Optional<Plugin> vmPlugin = MojoUtils.hasPlugin(this.project, "io.reactiverse:vertx-maven-plugin");
        if (vmPlugin.isPresent()) {
            return;
        }
        model.getProperties().putIfAbsent("vertx-maven-plugin.version", MojoUtils.getVersion("vertx-maven-plugin-version"));
        this.vertxVersion = this.vertxVersion == null ? MojoUtils.getVersion(VERTX_CORE_VERSION) : this.vertxVersion;
        model.getProperties().putIfAbsent("vertx.version", this.vertxVersion);
        if (!Strings.isNullOrEmpty((String)this.verticle)) {
            if (this.verticle.endsWith(JAVA_EXTENSION)) {
                this.verticle = this.verticle.substring(0, this.verticle.length() - JAVA_EXTENSION.length());
            }
            model.getProperties().putIfAbsent("vertx.verticle", this.verticle);
        }
        this.addVertxBom(model);
        this.addVertxDependencies(model);
        this.addDependencies(model);
        Plugin vertxMavenPlugin = MojoExecutor.plugin((String)"io.reactiverse", (String)"vertx-maven-plugin", (String)"${vertx-maven-plugin.version}");
        if (this.isParentPom(model)) {
            this.addPluginManagementSection(model, vertxMavenPlugin);
            vertxMavenPlugin = MojoExecutor.plugin((String)"io.reactiverse", (String)"vertx-maven-plugin");
        } else {
            vertxMavenPlugin = MojoExecutor.plugin((String)"io.reactiverse", (String)"vertx-maven-plugin", (String)"${vertx-maven-plugin.version}");
        }
        PluginExecution pluginExec = new PluginExecution();
        pluginExec.addGoal("initialize");
        pluginExec.addGoal("package");
        pluginExec.setId("vmp");
        vertxMavenPlugin.addExecution(pluginExec);
        vertxMavenPlugin.setConfiguration((Object)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"redeploy", (String)"true")}));
        Build build = this.createBuildSectionIfRequired(model);
        build.getPlugins().add(vertxMavenPlugin);
        this.save(pomFile, model);
    }

    private Build createBuildSectionIfRequired(Model model) {
        Build build = model.getBuild();
        if (build == null) {
            build = new Build();
            model.setBuild(build);
        }
        if (build.getPlugins() == null) {
            build.setPlugins(new ArrayList());
        }
        return build;
    }

    private void addPluginManagementSection(Model model, Plugin vertxMavenPlugin) {
        if (model.getBuild().getPluginManagement() != null) {
            if (model.getBuild().getPluginManagement().getPlugins() == null) {
                model.getBuild().getPluginManagement().setPlugins(new ArrayList());
            }
            model.getBuild().getPluginManagement().getPlugins().add(vertxMavenPlugin);
        }
    }

    private File createPomFileFromUserInputs() throws MojoExecutionException {
        Model model;
        String workingdDir = System.getProperty("user.dir");
        this.getLog().info((CharSequence)("No pom.xml found, creating it in " + workingdDir));
        File pomFile = new File(workingdDir, "pom.xml");
        try {
            if (this.projectGroupId == null) {
                this.projectGroupId = this.prompter.promptWithDefaultValue("Set the project groupId", "io.vertx.example");
            }
            if (this.projectArtifactId == null) {
                this.projectArtifactId = this.prompter.promptWithDefaultValue("Set the project artifactId", "my-vertx-project");
                this.projectVersion = this.prompter.promptWithDefaultValue("Set the project version", "1.0-SNAPSHOT");
                if (this.vertxVersion == null) {
                    this.vertxVersion = this.prompter.promptWithDefaultValue("Set the Vert.x version", MojoUtils.getVersion(VERTX_CORE_VERSION));
                }
                if (this.verticle == null) {
                    this.verticle = this.prompter.promptWithDefaultValue("Set the verticle class name", this.projectGroupId.replace("-", ".").replace("_", ".") + ".MainVerticle");
                }
            }
            if (this.verticle != null && this.verticle.endsWith(JAVA_EXTENSION)) {
                this.verticle = this.verticle.substring(0, this.verticle.length() - JAVA_EXTENSION.length());
            }
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("mProjectGroupId", this.projectGroupId);
            context.put("mProjectArtifactId", this.projectArtifactId);
            context.put("mProjectVersion", this.projectVersion);
            context.put("vertxVersion", this.vertxVersion != null ? this.vertxVersion : MojoUtils.getVersion(VERTX_CORE_VERSION));
            context.put("vertxVerticle", this.verticle);
            context.put("vmpVersion", MojoUtils.getVersion("vertx-maven-plugin-version"));
            SetupTemplateUtils.createPom(context, pomFile);
            MavenXpp3Reader xpp3Reader = new MavenXpp3Reader();
            model = xpp3Reader.read((InputStream)new FileInputStream(pomFile));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while setup of vertx-maven-plugin", e);
        }
        this.project = new MavenProject(model);
        this.project.setPomFile(pomFile);
        this.project.setOriginalModel(model);
        if (this.addDependencies(model)) {
            this.save(pomFile, model);
        }
        return pomFile;
    }

    private void save(File pomFile, Model model) throws MojoExecutionException {
        MavenXpp3Writer xpp3Writer = new MavenXpp3Writer();
        try (FileWriter pomFileWriter = new FileWriter(pomFile);){
            xpp3Writer.write((Writer)pomFileWriter, model);
            pomFileWriter.flush();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write the pom.xml file", (Exception)e);
        }
    }

    private Dependency parse(String dependency) {
        Dependency res = new Dependency();
        String[] segments = dependency.split(":");
        if (segments.length >= 2) {
            res.setGroupId(segments[0]);
            res.setArtifactId(segments[1]);
            if (segments.length >= 3 && !segments[2].isEmpty()) {
                res.setVersion(segments[2]);
            }
            if (segments.length >= 4) {
                res.setClassifier(segments[3]);
            }
            return res;
        }
        this.getLog().warn((CharSequence)("Invalid dependency description '" + dependency + "'"));
        return null;
    }

    private boolean addDependencies(Model model) {
        if (this.dependencies == null || this.dependencies.isEmpty()) {
            return false;
        }
        boolean updated = false;
        List<VertxDependency> deps = VertxDependencies.get();
        for (String dependency : this.dependencies) {
            Optional<VertxDependency> optional = deps.stream().filter(d -> d.labels().contains(dependency.toLowerCase())).findAny();
            if (optional.isPresent()) {
                this.getLog().info((CharSequence)("Adding dependency " + optional.get().toCoordinates()));
                model.addDependency(optional.get().toDependency());
                updated = true;
                continue;
            }
            if (dependency.contains(":")) {
                Dependency parsed = this.parse(dependency);
                if (parsed == null) continue;
                this.getLog().info((CharSequence)("Adding dependency " + parsed.getManagementKey()));
                model.addDependency(parsed);
                updated = true;
                continue;
            }
            this.getLog().warn((CharSequence)("Cannot find a dependency matching '" + dependency + "'"));
        }
        return updated;
    }

    private void createDirectories() {
        boolean res;
        File root = this.project.getBasedir();
        File source = new File(root, "src/main/java");
        File resources = new File(root, "src/main/resources");
        File test = new File(root, "src/test/java");
        String prefix = "Creation of ";
        if (!source.isDirectory()) {
            res = source.mkdirs();
            this.getLog().debug((CharSequence)(prefix + source.getAbsolutePath() + " : " + res));
        }
        if (!resources.isDirectory()) {
            res = resources.mkdirs();
            this.getLog().debug((CharSequence)(prefix + resources.getAbsolutePath() + " : " + res));
        }
        if (!test.isDirectory()) {
            res = test.mkdirs();
            this.getLog().debug((CharSequence)(prefix + test.getAbsolutePath() + " : " + res));
        }
    }

    private boolean isParentPom(Model model) {
        return "pom".equals(model.getPackaging());
    }

    private void addVertxDependencies(Model model) {
        String groupId = VERTX_GROUP_ID;
        String artifactId = "vertx-core";
        if (model.getDependencies() != null) {
            if (!MojoUtils.hasDependency(this.project, groupId, artifactId)) {
                model.getDependencies().add(MojoExecutor.dependency((String)groupId, (String)artifactId, null));
            }
        } else {
            model.setDependencies(new ArrayList());
            model.getDependencies().add(MojoExecutor.dependency((String)groupId, (String)artifactId, null));
        }
    }

    private void addVertxBom(Model model) {
        Dependency vertxBom = MojoExecutor.dependency((String)VERTX_GROUP_ID, (String)"vertx-stack-depchain", (String)"${vertx.version}");
        vertxBom.setType("pom");
        vertxBom.setScope("import");
        if (model.getDependencyManagement() != null) {
            if (!MojoUtils.hasDependency(this.project, VERTX_GROUP_ID, "vertx-stack-depchain")) {
                model.getDependencyManagement().addDependency(vertxBom);
            }
        } else {
            DependencyManagement dm = new DependencyManagement();
            dm.addDependency(vertxBom);
            model.setDependencyManagement(dm);
        }
    }
}

