/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.utils;

import io.reactiverse.vertx.maven.plugin.utils.ExecUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.cli.Arg;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamPumper;
import org.jvnet.winp.WinProcess;

public class JavaProcessExecutor {
    private List<String> argsList = new ArrayList<String>();
    private Log logger;
    private boolean waitFor = true;
    private File workingDirectory;
    private Map<String, String> environment = new HashMap<String, String>();
    protected List<String> jvmArgs;
    private final File java = this.findJava();
    private Collection<URL> classPathUrls;

    public Process execute() throws Exception {
        Commandline commandLine = this.buildCommandLine();
        Process process = null;
        try {
            this.logger.debug((CharSequence)("Executing command :" + commandLine));
            Process reference = process = commandLine.execute();
            Thread watchdog = new Thread(() -> this.destroy(reference));
            Runtime.getRuntime().addShutdownHook(watchdog);
            if (this.waitFor) {
                this.redirect(process.getInputStream(), System.out);
                this.redirect(process.getErrorStream(), System.err);
                process.waitFor();
                if (!process.isAlive()) {
                    Runtime.getRuntime().removeShutdownHook(watchdog);
                }
            }
            return process;
        }
        catch (InterruptedException e) {
            this.destroy(process);
            Thread.currentThread().interrupt();
            return process;
        }
        catch (Exception e) {
            this.destroy(process);
            throw new Exception("Error running java command : " + e.getMessage(), e);
        }
    }

    private void destroy(Process process) {
        if (process == null || !process.isAlive()) {
            return;
        }
        if (!SystemUtils.IS_OS_WINDOWS) {
            process.destroy();
        } else {
            WinProcess winProcess = this.getWinProcess(process);
            if (!winProcess.sendCtrlC()) {
                this.logger.warn((CharSequence)"Failed to send Ctrl-C signal");
            }
        }
    }

    private WinProcess getWinProcess(Process process) {
        WinProcess winProcess;
        Method pidMethod = this.findPidMethod();
        if (pidMethod != null) {
            int pid;
            try {
                pid = Math.toIntExact((Long)pidMethod.invoke((Object)process, new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            winProcess = new WinProcess(pid);
        } else {
            winProcess = new WinProcess(process);
        }
        return winProcess;
    }

    private Method findPidMethod() {
        for (Method method : Process.class.getMethods()) {
            if (!"pid".equals(method.getName()) || method.getParameterCount() != 0) continue;
            return method;
        }
        return null;
    }

    private Commandline buildCommandLine() throws Exception {
        Commandline cli = new Commandline();
        cli.getShell().setQuotedArgumentsEnabled(false);
        cli.setExecutable(this.java.getAbsolutePath());
        this.environment.forEach((arg_0, arg_1) -> ((Commandline)cli).addEnvironment(arg_0, arg_1));
        cli.setWorkingDirectory(this.workingDirectory);
        this.addClasspath(this.argsList);
        this.argsLine(cli);
        return cli;
    }

    private void argsLine(Commandline commandline) {
        if (this.jvmArgs == null) {
            return;
        }
        ArrayList<String> full = new ArrayList<String>(this.jvmArgs);
        full.addAll(this.argsList);
        full.forEach(arg -> {
            Arg cliArg = commandline.createArg();
            cliArg.setValue(arg);
        });
    }

    public JavaProcessExecutor withArgs(List<String> argsList) {
        this.argsList = argsList;
        return this;
    }

    public JavaProcessExecutor withLogger(Log logger) {
        this.logger = logger;
        return this;
    }

    public JavaProcessExecutor withClassPath(Collection<URL> classPathUrls) {
        this.classPathUrls = classPathUrls;
        return this;
    }

    public JavaProcessExecutor withWaitFor(boolean waitFor) {
        this.waitFor = waitFor;
        return this;
    }

    public JavaProcessExecutor withEnvVar(String name, String value) {
        this.environment.put(name, value);
        return this;
    }

    public JavaProcessExecutor withJvmOpts(List<String> jvmArgs) {
        this.jvmArgs = jvmArgs == null ? Collections.emptyList() : jvmArgs;
        return this;
    }

    public JavaProcessExecutor withWorkDirectory(File directory) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("The working directory " + directory.getAbsolutePath() + " is not a directory");
        }
        this.workingDirectory = directory;
        return this;
    }

    private void redirect(InputStream in, PrintStream ps) {
        StreamPumper pumper = new StreamPumper(in, new PrintWriter(new BufferedOutputStream(ps)));
        pumper.setPriority(2);
        pumper.start();
    }

    private void addClasspath(List<String> argsList) throws MojoExecutionException {
        try {
            StringBuilder classpath = new StringBuilder();
            for (URL ele : this.classPathUrls) {
                classpath.append(classpath.length() > 0 ? File.pathSeparator : "");
                classpath.append(new File(ele.toURI()));
            }
            String oldClasspath = System.getProperty("java.class.path");
            if (oldClasspath != null) {
                classpath.append(File.pathSeparator);
                classpath.append(oldClasspath);
            }
            if (SystemUtils.IS_OS_WINDOWS) {
                classpath.insert(0, '\"').append('\"');
            }
            argsList.add(0, "-cp");
            argsList.add(1, classpath.toString());
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Could not build classpath", ex);
        }
    }

    private File findJava() {
        File found;
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) {
            found = ExecUtils.findExecutableInSystemPath("java");
        } else {
            File bin = new File(javaHome, "bin");
            found = ExecUtils.find("java", bin);
        }
        if (found == null || !found.isFile()) {
            throw new IllegalStateException("Unable to find the java executable in JAVA_HOME or in the system path");
        }
        return found;
    }
}

