/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.components.impl;

import io.reactiverse.vertx.maven.plugin.components.ServiceFileCombinationConfig;
import io.reactiverse.vertx.maven.plugin.components.ServiceFileCombiner;
import io.reactiverse.vertx.maven.plugin.components.ServiceUtils;
import io.reactiverse.vertx.maven.plugin.components.impl.merge.MergeResult;
import io.reactiverse.vertx.maven.plugin.components.impl.merge.MergingStrategy;
import io.reactiverse.vertx.maven.plugin.model.CombinationStrategy;
import io.reactiverse.vertx.maven.plugin.mojos.DependencySet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.resolve.ScopeFilter;
import org.apache.maven.shared.artifact.filter.resolve.transform.ArtifactIncludeFilterTransformer;
import org.apache.maven.shared.utils.io.DirectoryScanner;
import org.apache.maven.shared.utils.io.SelectorUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

@Component(role=ServiceFileCombiner.class)
public class ServiceFileCombinationImpl
implements ServiceFileCombiner {
    @Override
    public void doCombine(ServiceFileCombinationConfig config) {
        if (config.getStrategy() == CombinationStrategy.NONE) {
            return;
        }
        List<String> patterns = config.getArchive().getFileCombinationPatterns();
        if (patterns.isEmpty()) {
            return;
        }
        Log logger = Objects.requireNonNull(config.getMojo().getLog());
        List<DependencySet> sets = config.getArchive().getDependencySets();
        if (sets.isEmpty()) {
            DependencySet set = new DependencySet();
            set.addInclude("*");
            sets.add(set);
        }
        for (DependencySet ds : sets) {
            ScopeFilter scopeFilter = ServiceUtils.newScopeFilter(ds.getScope());
            ArtifactFilter filter = new ArtifactIncludeFilterTransformer().transform(scopeFilter);
            Set<Artifact> artifacts = ServiceUtils.filterArtifacts(config.getArtifacts(), ds.getIncludes(), ds.getExcludes(), ds.isUseTransitiveDependencies(), logger, filter);
            try {
                List<File> files = artifacts.stream().map(Artifact::getFile).filter(File::isFile).filter(f -> f.getName().endsWith(".jar")).collect(Collectors.toList());
                this.combine(config.getProject(), patterns, logger, files);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to combine SPI files for " + config.getProject().getArtifactId(), e);
            }
        }
    }

    private void combine(MavenProject project, List<String> patterns, Log logger, List<File> dependencies) {
        Map<String, Asset> locals = ServiceFileCombinationImpl.findLocalDescriptors(project, patterns);
        Map<String, List<Asset>> deps = ServiceFileCombinationImpl.findDescriptorsFromDependencies(dependencies, patterns);
        logger.debug((CharSequence)("Descriptors declared in the project: " + locals.keySet()));
        logger.debug((CharSequence)("Descriptors declared in dependencies: " + deps.keySet()));
        LinkedHashSet<String> descriptorsToMerge = new LinkedHashSet<String>(locals.keySet());
        descriptorsToMerge.addAll(deps.keySet());
        HashMap<String, MergeResult> descriptors = new HashMap<String, MergeResult>();
        for (String name2 : descriptorsToMerge) {
            MergingStrategy strategy = MergingStrategy.forName(name2);
            descriptors.put(name2, strategy.merge(project, locals.get(name2), deps.get(name2)));
        }
        File out = new File(project.getBuild().getOutputDirectory());
        descriptors.forEach((name, content) -> {
            File merged = new File(out, (String)name);
            try {
                content.writeTo(merged);
                logger.debug((CharSequence)("Descriptor combined into " + merged.getAbsolutePath()));
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot write combined Descriptor files", e);
            }
        });
    }

    private static Map<String, Asset> findLocalDescriptors(MavenProject project, List<String> patterns) {
        String[] paths;
        LinkedHashMap<String, Asset> map = new LinkedHashMap<String, Asset>();
        File classes = new File(project.getBuild().getOutputDirectory());
        if (!classes.isDirectory()) {
            return map;
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(classes);
        scanner.setIncludes(patterns.toArray(new String[0]));
        scanner.scan();
        for (String p : paths = scanner.getIncludedFiles()) {
            File file = new File(classes, p);
            if (!file.isFile()) continue;
            String relative = classes.toURI().relativize(file.toURI()).getPath().replace("\\", "/");
            map.put("/" + relative, (Asset)new FileAsset(file));
        }
        return map;
    }

    private static Map<String, List<Asset>> findDescriptorsFromDependencies(List<File> deps, List<String> patterns) {
        LinkedHashMap<String, List<Asset>> map = new LinkedHashMap<String, List<Asset>>();
        for (File file : deps) {
            JavaArchive archive = (JavaArchive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)file);
            Map<ArchivePath, Node> content = ServiceFileCombinationImpl.getMatchingFilesFromJar(patterns, archive);
            for (Map.Entry<ArchivePath, Node> entry : content.entrySet()) {
                Asset asset = entry.getValue().getAsset();
                if (asset == null) continue;
                String path = entry.getKey().get();
                List items = map.computeIfAbsent(path, k -> new ArrayList());
                items.add(asset);
                map.put(path, items);
            }
        }
        return map;
    }

    private static Map<ArchivePath, Node> getMatchingFilesFromJar(List<String> patterns, JavaArchive archive) {
        return archive.getContent(path -> {
            for (String pattern : patterns) {
                if (!SelectorUtils.match((String)pattern, (String)path.get())) continue;
                return true;
            }
            return false;
        });
    }
}

