/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.components.impl.merge;

import io.reactiverse.vertx.maven.plugin.components.impl.merge.MergeResult;
import io.reactiverse.vertx.maven.plugin.components.impl.merge.MergingStrategy;
import io.reactiverse.vertx.maven.plugin.components.impl.merge.TextResult;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.maven.project.MavenProject;
import org.jboss.shrinkwrap.api.asset.Asset;

public class AppendStrategy
implements MergingStrategy {
    @Override
    public MergeResult merge(MavenProject project, Asset local, List<Asset> deps) {
        LinkedHashSet<String> fromDeps = new LinkedHashSet<String>();
        if (deps != null) {
            deps.stream().map(this::readLines).forEach(fromDeps::addAll);
        }
        if (local != null) {
            List<String> lines = this.readLines(local);
            if (lines.isEmpty()) {
                return new TextResult(Collections.emptyList());
            }
            return this.computeOutput(lines, fromDeps);
        }
        return new TextResult(new ArrayList<String>(fromDeps));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> readLines(Asset asset) {
        try (InputStream is = asset.openStream();){
            List list = IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8);
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private MergeResult computeOutput(List<String> local, Set<String> fromDeps) {
        LinkedHashSet<String> lines = new LinkedHashSet<String>();
        for (String line : local) {
            if (line.trim().equalsIgnoreCase("${COMBINE}")) {
                lines.addAll(fromDeps);
                continue;
            }
            lines.add(line);
        }
        return new TextResult(new ArrayList<String>(lines));
    }
}

