/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.mojos;

import io.reactiverse.vertx.maven.plugin.mojos.AbstractRunMojo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="stop", requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class StopMojo
extends AbstractRunMojo {
    @Parameter(alias="appIds")
    protected Set<String> appIds;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"vertx:stop skipped by configuration");
            return;
        }
        this.vertxCommand = "stop";
        this.getAppId();
        ArrayList<String> argsList = new ArrayList<String>();
        for (String vertxProcId : this.appIds) {
            try {
                this.addClasspath(argsList);
                argsList.add("io.vertx.core.Launcher");
                argsList.add(this.vertxCommand);
                argsList.add(vertxProcId);
                this.run(argsList);
                Files.delete(Paths.get(this.workDirectory.toString(), "vertx-start-process.id"));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to read process file from directory :" + this.workDirectory.toString());
            }
        }
    }

    private void getAppId() throws MojoExecutionException {
        Path vertxPidFile;
        if (this.appIds == null) {
            this.appIds = new HashSet<String>();
        }
        if (Files.exists(vertxPidFile = Paths.get(this.workDirectory.toString(), "vertx-start-process.id"), new LinkOption[0])) {
            try {
                byte[] bytes = Files.readAllBytes(vertxPidFile);
                this.appIds.add(new String(bytes));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error reading vertx-start-process.id", (Exception)e);
            }
        }
    }
}

