/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.utils;

import io.reactiverse.vertx.maven.plugin.components.impl.ProjectManifestCustomizer;
import io.reactiverse.vertx.maven.plugin.model.ExtraManifestKeys;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.changelog.ChangeLogScmRequest;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmUrlUtils;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;

public class ScmSpy {
    private final ScmManager scmManager;

    public ScmSpy(ScmManager scmManager) {
        this.scmManager = scmManager;
    }

    public String getScmType(String scmUrl) throws ScmRepositoryException, NoSuchScmProviderException {
        return ScmUrlUtils.getProvider((String)scmUrl);
    }

    public Map<ExtraManifestKeys, String> getChangeLog(String scmUrl, File workingDir) throws IOException, ScmException {
        List changeSetList;
        HashMap<ExtraManifestKeys, String> changeLogMap = new HashMap<ExtraManifestKeys, String>();
        ScmRepository scmRepository = this.scmManager.makeScmRepository(scmUrl);
        ChangeLogScmResult scmResult = this.scmManager.changeLog(new ChangeLogScmRequest(scmRepository, new ScmFileSet(workingDir, "*")));
        if (scmResult.isSuccess() && (changeSetList = scmResult.getChangeLog().getChangeSets()) != null && !changeSetList.isEmpty()) {
            ChangeSet changeSet = (ChangeSet)changeSetList.get(0);
            changeLogMap.put(ExtraManifestKeys.SCM_TYPE, this.getScmType(scmUrl));
            changeLogMap.put(ExtraManifestKeys.SCM_REVISION, changeSet.getRevision());
            changeLogMap.put(ExtraManifestKeys.LAST_COMMIT_TIMESTAMP, ProjectManifestCustomizer.manifestTimestampFormat(changeSet.getDate()));
            changeLogMap.put(ExtraManifestKeys.SCM_AUTHOR, changeSet.getAuthor());
        }
        return changeLogMap;
    }
}

