/*
 * Decompiled with CFR 0.152.
 */
package restx.admin;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import javax.inject.Named;
import restx.AppSettings;
import restx.FSRouter;
import restx.ResourcesRoute;
import restx.RestxRouter;
import restx.admin.AdminPage;
import restx.factory.Module;
import restx.factory.Provides;

@Module
public class SourcesModule {
    private static final RestxRouter NO_SOURCES = RestxRouter.builder().name("NO-SOURCES").build();

    @Named(value="Sources")
    @Provides
    public AdminPage getSourcesAdminPage() {
        return new AdminPage("/@/ui/sources/", "Sources");
    }

    @Provides
    public ResourcesRoute sourceUI() {
        return new ResourcesRoute("SourcesUIRoute", "/@/ui/sources", "restx/sources", ImmutableMap.of((Object)"", (Object)"index.html"));
    }

    @Provides
    public RestxRouter mountSources(AppSettings appSettings) {
        if (!"dev".equals(appSettings.mode())) {
            return NO_SOURCES;
        }
        return (RestxRouter)this.sourcesRouter(appSettings).or((Object)NO_SOURCES);
    }

    public Optional<RestxRouter> sourcesRouter(AppSettings appSettings) {
        if (new File(appSettings.mainSources()).exists()) {
            return Optional.of((Object)FSRouter.mount((String)appSettings.mainSources()).allowDirectoryListing().on("/@/sources/main/"));
        }
        return Optional.absent();
    }

    @Provides
    public RestxRouter mountResources(AppSettings appSettings) {
        if (!"dev".equals(appSettings.mode())) {
            return NO_SOURCES;
        }
        return (RestxRouter)this.resourcesRouter(appSettings).or((Object)NO_SOURCES);
    }

    public Optional<RestxRouter> resourcesRouter(AppSettings appSettings) {
        if (new File(appSettings.mainResources()).exists()) {
            return Optional.of((Object)FSRouter.mount((String)appSettings.mainResources()).allowDirectoryListing().on("/@/sources/resources/"));
        }
        return Optional.absent();
    }
}

