/*
 * Decompiled with CFR 0.152.
 */
package restx.config;

import com.google.common.base.Optional;
import java.io.IOException;
import java.lang.reflect.Type;
import javax.validation.Validator;
import restx.RestxLogLevel;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxRequestMatcher;
import restx.RestxRoute;
import restx.RestxRouter;
import restx.StdRestxRequestMatcher;
import restx.common.ConfigElement;
import restx.common.Types;
import restx.config.ConfigResource;
import restx.converters.MainStringConverter;
import restx.description.OperationDescription;
import restx.entity.EntityRequestBodyReaderRegistry;
import restx.entity.EntityResponseWriterRegistry;
import restx.entity.StdEntityRoute;
import restx.factory.Component;
import restx.http.HttpStatus;
import restx.security.Permissions;
import restx.security.RestxSecurityManager;

@Component(priority=0)
public class ConfigResourceRouter
extends RestxRouter {
    public ConfigResourceRouter(final ConfigResource resource, EntityRequestBodyReaderRegistry readerRegistry, EntityResponseWriterRegistry writerRegistry, MainStringConverter converter, Optional<Validator> validator, final RestxSecurityManager securityManager) {
        super("restx-admin", "ConfigResourceRouter", new RestxRoute[]{new StdEntityRoute<Void, Iterable<ConfigElement>>("restx-admin#ConfigResource#findConfigElements", readerRegistry.build(Void.class, Optional.absent()), writerRegistry.build((Type)Types.newParameterizedType(Iterable.class, (Type[])new Type[]{ConfigElement.class}), Optional.absent()), (RestxRequestMatcher)new StdRestxRequestMatcher("GET", "/@/config/elements"), HttpStatus.OK, RestxLogLevel.DEFAULT){

            protected Optional<Iterable<ConfigElement>> doRoute(RestxRequest request, RestxRequestMatch match, Void body) throws IOException {
                securityManager.check(request, Permissions.isAuthenticated());
                return Optional.of(resource.findConfigElements());
            }

            protected void describeOperation(OperationDescription operation) {
                super.describeOperation(operation);
                operation.responseClass = "LIST[ConfigElement]";
                operation.inEntitySchemaKey = "";
                operation.outEntitySchemaKey = "restx.common.ConfigElement";
                operation.sourceLocation = "restx.config.ConfigResource#findConfigElements()";
            }
        }});
    }
}

