/*
 * Decompiled with CFR 0.152.
 */
package restx.server;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import restx.common.MoreFiles;
import restx.common.MoreIO;
import restx.common.Version;
import restx.server.WebServer;
import restx.server.WebServerSupplier;
import restx.server.WebServers;

public class JettyWebServer
implements WebServer {
    private static final AtomicLong SERVER_ID = new AtomicLong();
    private static final Logger logger = LoggerFactory.getLogger(JettyWebServer.class);
    private Server server;
    private int port;
    private String bindInterface;
    private String appBase;
    private String webInfLocation;
    private String serverId;

    public JettyWebServer(String appBase, int aPort) {
        this(null, appBase, aPort, null);
    }

    public JettyWebServer(String webInfLocation, String appBase, int port, String bindInterface) {
        MoreFiles.checkFileExists((String)((String)Preconditions.checkNotNull((Object)appBase)));
        if (webInfLocation != null) {
            MoreFiles.checkFileExists((String)webInfLocation);
        }
        this.port = port;
        this.bindInterface = bindInterface;
        this.appBase = appBase;
        this.webInfLocation = webInfLocation;
        this.serverId = "Jetty#" + SERVER_ID.incrementAndGet();
    }

    public synchronized JettyWebServer setServerId(String serverId) {
        if (this.isStarted()) {
            throw new IllegalStateException("can't set server id when server is started");
        }
        this.serverId = serverId;
        return this;
    }

    public String getServerId() {
        return this.serverId;
    }

    public int getPort() {
        return this.port;
    }

    public String baseUrl() {
        return WebServers.baseUri((String)"127.0.0.1", (int)this.port);
    }

    public String getServerType() {
        return "Jetty " + Version.getVersion((String)"org.eclipse.jetty", (String)"jetty-server") + ", embedded";
    }

    public synchronized void start() throws Exception {
        MoreIO.checkCanOpenSocket((int)this.port);
        this.server = new Server();
        WebServers.register((WebServer)this);
        this.server.setThreadPool(this.createThreadPool());
        this.server.addConnector((Connector)this.createConnector());
        this.server.setHandler((Handler)this.createHandlers(this.createContext()));
        this.server.setStopAtShutdown(true);
        this.server.start();
    }

    public void startAndAwait() throws Exception {
        this.start();
        this.await();
    }

    public void await() throws InterruptedException {
        this.server.join();
    }

    public synchronized void stop() throws Exception {
        this.server.stop();
        this.server = null;
        WebServers.unregister((String)this.serverId);
    }

    public synchronized boolean isStarted() {
        return this.server != null;
    }

    protected ThreadPool createThreadPool() {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMinThreads(1);
        threadPool.setMaxThreads(Math.max(10, Runtime.getRuntime().availableProcessors()));
        return threadPool;
    }

    protected SelectChannelConnector createConnector() {
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.port);
        connector.setHost(this.bindInterface);
        return connector;
    }

    protected HandlerCollection createHandlers(WebAppContext webAppContext) {
        HandlerList contexts = new HandlerList();
        contexts.setHandlers(new Handler[]{webAppContext});
        HandlerCollection result = new HandlerCollection();
        result.setHandlers(new Handler[]{contexts});
        return result;
    }

    protected WebAppContext createContext() {
        final WebAppContext ctx = new WebAppContext();
        ctx.setContextPath("/");
        ctx.setWar(this.appBase);
        if (!Strings.isNullOrEmpty((String)this.webInfLocation)) {
            ctx.setDescriptor(this.webInfLocation);
        }
        HashLoginService loginService = new HashLoginService();
        loginService.setIdentityService((IdentityService)new DefaultIdentityService());
        ctx.getSecurityHandler().setLoginService((LoginService)loginService);
        ctx.getSecurityHandler().setIdentityService(loginService.getIdentityService());
        ctx.addLifeCycleListener((LifeCycle.Listener)new AbstractLifeCycle.AbstractLifeCycleListener(){

            public void lifeCycleStarting(LifeCycle event) {
                ctx.getServletContext().setInitParameter("restx.baseServerUri", JettyWebServer.this.baseUrl());
                ctx.getServletContext().setInitParameter("restx.serverId", JettyWebServer.this.getServerId());
            }
        });
        return ctx;
    }

    public static WebServerSupplier jettyWebServerSupplier(final String webInfLocation, final String appBase) {
        return new WebServerSupplier(){

            public WebServer newWebServer(int port) {
                return new JettyWebServer(webInfLocation, appBase, port, "0.0.0.0");
            }
        };
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("usage: jetty-run <appbase> [<port>]");
            System.exit(1);
        }
        String appBase = args[0];
        int port = args.length > 1 ? Integer.parseInt(args[1]) : 8086;
        new JettyWebServer(appBase + "WEB-INF/web.xml", appBase, port, "0.0.0.0").startAndAwait();
    }
}

